"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Wrapper = exports.WithoutHeaderLayout = exports.Page = exports.ContentWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Wrapper = _styledComponents.default.div`
  background-color: ${props => props.theme.eui.euiColorEmptyShade};

  // HACK: Kibana introduces a div element around the app component that results in us
  // being unable to stretch this Wrapper to full height via flex: 1. This calc sets
  // the min height to the viewport size minus the height of the two global Kibana headers.
  min-height: calc(
    100vh - ${props => parseFloat(props.theme.eui.euiHeaderHeightCompensation) * 2}px
  );
`;
exports.Wrapper = Wrapper;
const Page = (0, _styledComponents.default)(_eui.EuiPage)`
  background: ${props => props.theme.eui.euiColorEmptyShade};
  width: 100%;
  align-self: center;
  margin: auto;
  flex: 1;
`;
exports.Page = Page;
const ContentWrapper = _styledComponents.default.div`
  height: 100%;
`;
exports.ContentWrapper = ContentWrapper;
const WithoutHeaderLayout = ({
  restrictWidth,
  children
}) => /*#__PURE__*/_react.default.createElement(Wrapper, null, /*#__PURE__*/_react.default.createElement(Page, {
  restrictWidth: restrictWidth || 1200
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(ContentWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), children))));
exports.WithoutHeaderLayout = WithoutHeaderLayout;