"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetDataStreams = exports.sendGetDataStreams = void 0;
var _services = require("../../services");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetDataStreams = () => {
  return (0, _use_request.useRequest)({
    path: _services.dataStreamRouteService.getListPath(),
    method: 'get'
  });
};
exports.useGetDataStreams = useGetDataStreams;
const sendGetDataStreams = async () => {
  const res = await (0, _use_request.sendRequest)({
    path: _services.dataStreamRouteService.getListPath(),
    method: 'get'
  });
  if (res.error) {
    throw res.error;
  }
  return res.data;
};
exports.sendGetDataStreams = sendGetDataStreams;