"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePackageInstallationsQuery = void 0;
var _react = require("react");
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _constants = require("../../common/constants");
var _epm = require("./use_request/epm");
var _agent_policy = require("./use_request/agent_policy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePackageInstallationsQuery = () => {
  const {
    data: allPackages,
    isLoading: isLoadingPackages
  } = (0, _epm.useGetPackagesQuery)({
    prerelease: true
  });
  const {
    data: agentPolicyData,
    isLoading: isLoadingPolicies
  } = (0, _agent_policy.useGetAgentPoliciesQuery)({
    full: true
  });
  const allInstalledPackages = (0, _react.useMemo)(() => ((allPackages === null || allPackages === void 0 ? void 0 : allPackages.items) || []).filter(pkg => pkg.status === _constants.installationStatuses.Installed), [allPackages === null || allPackages === void 0 ? void 0 : allPackages.items]);
  const updatablePackages = (0, _react.useMemo)(() => allInstalledPackages.filter(item => 'savedObject' in item && (0, _lt.default)(item.savedObject.attributes.version, item.version)), [allInstalledPackages]);
  const updatableIntegrations = (0, _react.useMemo)(() => ((agentPolicyData === null || agentPolicyData === void 0 ? void 0 : agentPolicyData.items) || []).reduce((result, policy) => {
    var _policy$package_polic;
    (_policy$package_polic = policy.package_policies) === null || _policy$package_polic === void 0 ? void 0 : _policy$package_polic.forEach(pkgPolicy => {
      if (!pkgPolicy.package) return false;
      const {
        name,
        version
      } = pkgPolicy.package;
      const installedPackage = allInstalledPackages.find(installedPkg => 'savedObject' in installedPkg && installedPkg.savedObject.attributes.name === name);
      if (installedPackage && 'savedObject' in installedPackage && (0, _lt.default)(version, installedPackage.savedObject.attributes.version)) {
        var _result$get, _policy$agents;
        const packageData = (_result$get = result.get(name)) !== null && _result$get !== void 0 ? _result$get : {
          currentVersion: installedPackage.savedObject.attributes.version,
          policiesToUpgrade: []
        };
        packageData.policiesToUpgrade.push({
          id: policy.id,
          name: policy.name,
          agentsCount: (_policy$agents = policy.agents) !== null && _policy$agents !== void 0 ? _policy$agents : 0,
          pkgPolicyId: pkgPolicy.id,
          pkgPolicyName: pkgPolicy.name,
          pkgPolicyIntegrationVersion: version
        });
        result.set(name, packageData);
      }
    });
    return result;
  }, new Map()), [allInstalledPackages, agentPolicyData]);
  return {
    allPackages,
    allInstalledPackages,
    updatablePackages,
    updatableIntegrations,
    isLoadingPackages,
    isLoadingPolicies
  };
};
exports.usePackageInstallationsQuery = usePackageInstallationsQuery;