"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLink = void 0;
var _constants = require("../constants");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSeparatePaths = (page, values = {}) => {
  return values ? _constants.pagePathGetters[page](values) : _constants.pagePathGetters[page]();
};
const useLink = () => {
  const core = (0, _.useStartServices)();
  return {
    getPath: (page, values = {}) => {
      return getSeparatePaths(page, values)[1];
    },
    getAbsolutePath: path => {
      return core.http.basePath.prepend(`${path}`);
    },
    getAssetsPath: path => core.http.basePath.prepend(`/plugins/${_constants.PLUGIN_ID}/assets/${path}`),
    getHref: (page, values) => {
      const [basePath, path] = getSeparatePaths(page, values);
      return core.http.basePath.prepend(`${basePath}${path}`);
    }
  };
};
exports.useLink = useLink;