"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsPackagePolicyUpgradable = void 0;
var _react = require("react");
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _constants = require("../../common/constants");
var _epm = require("./use_request/epm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsPackagePolicyUpgradable = () => {
  const {
    data: allPackages,
    isLoading: isLoadingPackages
  } = (0, _epm.useGetPackages)({
    prerelease: true
  });
  const allInstalledPackages = (0, _react.useMemo)(() => ((allPackages === null || allPackages === void 0 ? void 0 : allPackages.items) || []).filter(pkg => pkg.status === _constants.installationStatuses.Installed), [allPackages === null || allPackages === void 0 ? void 0 : allPackages.items]);
  const isPackagePolicyUpgradable = (0, _react.useCallback)(pkgPolicy => {
    if (!pkgPolicy.package) {
      return false;
    }
    const {
      name,
      version
    } = pkgPolicy.package;
    const installedPackage = allInstalledPackages.find(installedPkg => 'savedObject' in installedPkg && installedPkg.savedObject.attributes.name === name);
    if (installedPackage && 'savedObject' in installedPackage && (0, _lt.default)(version, installedPackage.savedObject.attributes.version)) {
      return true;
    }
    return false;
  }, [allInstalledPackages]);
  return {
    isPackagePolicyUpgradable,
    isLoadingPackages
  };
};
exports.useIsPackagePolicyUpgradable = useIsPackagePolicyUpgradable;