"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlyoutContext = exports.FlyoutContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const agentFlyoutContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const FlyoutContextProvider = ({
  children
}) => {
  const [isEnrollmentFlyoutOpen, setIsEnrollmentFlyoutOpen] = (0, _react.useState)(false);
  const [isFleetServerFlyoutOpen, setIsFleetServerFlyoutOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(agentFlyoutContext.Provider, {
    value: {
      isEnrollmentFlyoutOpen,
      openEnrollmentFlyout: () => {
        setIsEnrollmentFlyoutOpen(true);
      },
      closeEnrollmentFlyout: () => setIsEnrollmentFlyoutOpen(false),
      isFleetServerFlyoutOpen,
      openFleetServerFlyout: () => setIsFleetServerFlyoutOpen(true),
      closeFleetServerFlyout: () => setIsFleetServerFlyoutOpen(false)
    }
  }, children);
};
exports.FlyoutContextProvider = FlyoutContextProvider;
const useFlyoutContext = () => {
  const context = (0, _react.useContext)(agentFlyoutContext);
  if (!context) {
    throw new Error('useFlyoutContext must be used within a FlyoutContextProvider');
  }
  return context;
};
exports.useFlyoutContext = useFlyoutContext;