"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomLogsAssetsExtension = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _custom_assets_accordion = require("./components/custom_assets_accordion");
var _hooks = require("./hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomLogsAssetsExtension = () => {
  const {
    http
  } = (0, _hooks.useStartServices)();
  const logStreamUrl = http.basePath.prepend('/app/logs/stream');
  const views = [{
    name: _i18n.i18n.translate('xpack.fleet.assets.customLogs.name', {
      defaultMessage: 'Logs'
    }),
    url: logStreamUrl,
    description: _i18n.i18n.translate('xpack.fleet.assets.customLogs.description', {
      defaultMessage: 'View Custom logs data in Logs app'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_custom_assets_accordion.CustomAssetsAccordion, {
    views: views,
    initialIsOpen: true
  });
};
exports.CustomLogsAssetsExtension = CustomLogsAssetsExtension;