"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlatformSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../hooks");
var _kubernetes_instructions = require("./agent_enrollment_flyout/kubernetes_instructions");
var _cloud_formation_instructions = require("./agent_enrollment_flyout/cloud_formation_instructions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Otherwise the copy button is over the text
const CommandCode = _styledComponents.default.pre({
  overflow: 'auto'
});
const PlatformSelector = ({
  linuxCommand,
  macCommand,
  windowsCommand,
  linuxDebCommand,
  linuxRpmCommand,
  k8sCommand,
  hasK8sIntegration,
  hasK8sIntegrationMultiPage,
  isManaged,
  enrollToken,
  hasFleetServer,
  fullCopyButton,
  onCopy,
  cloudFormationTemplateUrl
}) => {
  const getInitialPlatform = (0, _react.useCallback)(() => {
    if (cloudFormationTemplateUrl) return 'cloudFormation';
    if (hasK8sIntegration) return 'kubernetes';
    return 'linux';
  }, [cloudFormationTemplateUrl, hasK8sIntegration]);
  const {
    platform,
    setPlatform
  } = (0, _hooks.usePlatform)(getInitialPlatform());

  // In case of fleet server installation or standalone agent without
  // Kubernetes integration in the policy use reduced platform options
  const isReduced = hasFleetServer || !isManaged && !hasK8sIntegration;
  const getPlatformOptions = (0, _react.useCallback)(() => {
    const platformOptions = isReduced ? _hooks.REDUCED_PLATFORM_OPTIONS : _hooks.PLATFORM_OPTIONS;
    if (cloudFormationTemplateUrl) {
      return platformOptions.concat(_hooks.CLOUD_FORMATION_PLATFORM_OPTION);
    }
    return platformOptions;
  }, [cloudFormationTemplateUrl, isReduced]);
  const [copyButtonClicked, setCopyButtonClicked] = (0, _react.useState)(false);
  const systemPackageCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.callout', {
      defaultMessage: 'We recommend using the installers (TAR/ZIP) over system packages (RPM/DEB) because they provide the ability to upgrade your agent with Fleet.'
    }),
    color: "warning",
    iconType: "warning"
  });
  const k8sCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.k8sCallout', {
      defaultMessage: 'We recommend adding the Kubernetes integration to your agent policy in order to get useful metrics and logs from your Kubernetes clusters.'
    }),
    color: "warning",
    iconType: "warning"
  });
  const commandsByPlatform = {
    linux: linuxCommand,
    mac: macCommand,
    windows: windowsCommand,
    deb: linuxDebCommand,
    rpm: linuxRpmCommand,
    kubernetes: k8sCommand,
    cloudFormation: ''
  };
  const onTextAreaClick = () => {
    if (onCopy) onCopy();
  };
  const onCopyButtonClick = copy => {
    copy();
    setCopyButtonClicked(true);
    if (onCopy) onCopy();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hasK8sIntegrationMultiPage && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    options: getPlatformOptions(),
    idSelected: platform,
    onChange: id => setPlatform(id),
    legend: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformSelectAriaLabel', {
      defaultMessage: 'Platform'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), (platform === 'deb' || platform === 'rpm') && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, systemPackageCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), platform === 'kubernetes' && !hasK8sIntegration && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, k8sCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), platform === 'kubernetes' && isManaged && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_kubernetes_instructions.KubernetesInstructions, {
    onCopy: onCopy,
    onDownload: onCopy,
    enrollmentAPIKey: enrollToken
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), platform === 'cloudFormation' && cloudFormationTemplateUrl && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_cloud_formation_instructions.CloudFormationInstructions, {
    cloudFormationTemplateUrl: cloudFormationTemplateUrl,
    enrollmentAPIKey: enrollToken
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), !hasK8sIntegrationMultiPage && platform !== 'cloudFormation' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, platform === 'kubernetes' && /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.kubernetesCommandInstructions",
    defaultMessage: "From the directory where the manifest is downloaded, run the apply command."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    onClick: onTextAreaClick,
    fontSize: "m",
    isCopyable: !fullCopyButton,
    paddingSize: "m",
    css: `
                max-width: 1100px;
              `
  }, /*#__PURE__*/_react.default.createElement(CommandCode, null, commandsByPlatform[platform])), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), fullCopyButton && /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: commandsByPlatform[platform]
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    iconType: "copyClipboard",
    size: "m",
    onClick: () => onCopyButtonClick(copy)
  }, copyButtonClicked ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentInstructions.copyButtonClicked",
    defaultMessage: "Copied"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentInstructions.copyButton",
    defaultMessage: "Copy to clipboard"
  }))))));
};
exports.PlatformSelector = PlatformSelector;