"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _hooks = require("../../hooks");
var _services = require("../../services");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TutorialModuleNotice = /*#__PURE__*/(0, _react.memo)(({
  moduleName
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    application
  } = (0, _hooks.useStartServices)();
  const hasIntegrationsPermissions = application.capabilities.navLinks.integrations;
  const {
    data: packagesData,
    isLoading
  } = (0, _hooks.useGetPackages)();
  const pkgInfo = !isLoading && (packagesData === null || packagesData === void 0 ? void 0 : packagesData.response) && packagesData.response.find(pkg => pkg.name === moduleName && pkg.name !== _constants.FLEET_APM_PACKAGE); // APM needs special handling

  if (hasIntegrationsPermissions && pkgInfo) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.homeIntegration.tutorialModule.noticeText",
      defaultMessage: "{notePrefix} A newer version of this module is {availableAsIntegrationLink}. To learn more about integrations and the new Elastic Agent, read our {blogPostLink}.",
      values: {
        notePrefix: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "iInCircle",
          style: {
            verticalAlign: 'baseline'
          },
          "aria-label": _i18n.i18n.translate('xpack.fleet.homeIntegration.tutorialModule.noticeText.notePrefix', {
            defaultMessage: 'Note'
          })
        }),
        availableAsIntegrationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: getHref('integration_details_overview', {
            pkgkey: (0, _services.pkgKeyFromPackageInfo)(pkgInfo)
          })
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.homeIntegration.tutorialModule.noticeText.integrationLink",
          defaultMessage: "available as an Elastic Agent integration"
        })),
        blogPostLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: "https://ela.st/elastic-agent-ga-announcement",
          external: true,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.homeIntegration.tutorialModule.noticeText.blogPostLink",
          defaultMessage: "announcement blog post"
        }))
      }
    }))));
  }
  return null;
});

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
var _default = TutorialModuleNotice;
exports.default = _default;
module.exports = exports.default;