"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallationModeSelectionStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InstallationModeSelectionStep = ({
  selectedPolicyId,
  mode,
  setMode
}) => {
  // radio id has to be unique so that the component works even if appears twice in DOM
  const radioSuffix = 'installation_mode_agent_selection';
  const onChangeCallback = v => {
    const value = v.split('_')[0];
    if (value === 'managed' || value === 'standalone') {
      setMode(value);
    }
  };
  return {
    status: selectedPolicyId ? undefined : 'disabled',
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepInstallType', {
      defaultMessage: 'Enroll in Fleet?'
    }),
    children: selectedPolicyId ? /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
      options: [{
        id: `managed_${radioSuffix}`,
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          "data-test-subj": "agentFlyoutManagedRadioButtons",
          id: "xpack.fleet.agentFlyout.managedRadioOption",
          defaultMessage: "{managed} \u2013 Enroll in Elastic Agent in Fleet to automatically deploy updates and centrally manage the agent.",
          values: {
            managed: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.fleet.agentFlyout.managedMessage",
              defaultMessage: "Enroll in Fleet (recommended)"
            }))
          }
        })
      }, {
        id: `standalone_${radioSuffix}`,
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          "data-test-subj": "agentFlyoutStandaloneRadioButtons",
          id: "xpack.fleet.agentFlyout.standaloneRadioOption",
          defaultMessage: "{standaloneMessage} \u2013 Run an Elastic Agent standalone to configure and update the agent manually on the host where the agent is installed.",
          values: {
            standaloneMessage: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.fleet.agentFlyout.standaloneMessage",
              defaultMessage: "Run standalone"
            }))
          }
        })
      }],
      idSelected: `${mode}_${radioSuffix}`,
      onChange: onChangeCallback,
      name: `radio group ${radioSuffix}`
    }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)
  };
};
exports.InstallationModeSelectionStep = InstallationModeSelectionStep;