"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallStandaloneAgentStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _install_section = require("../../enrollment_instructions/install_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InstallStandaloneAgentStep = ({
  installCommand,
  isK8s,
  isComplete,
  fullCopyButton,
  onCopy
}) => {
  return {
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepEnrollAndRunAgentTitle', {
      defaultMessage: 'Install Elastic Agent on your host'
    }),
    children: /*#__PURE__*/_react.default.createElement(_install_section.InstallSection, {
      installCommand: installCommand,
      isK8s: isK8s,
      onCopy: onCopy,
      fullCopyButton: fullCopyButton,
      isManaged: false
    }),
    status: isComplete ? 'complete' : undefined
  };
};
exports.InstallStandaloneAgentStep = InstallStandaloneAgentStep;