"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  AgentEnrollmentFlyout: true
};
exports.AgentEnrollmentFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../hooks");
var _constants = require("../../constants");
var _ = require("..");
var _instructions = require("./instructions");
Object.keys(_instructions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _instructions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _instructions[key];
    }
  });
});
var _missing_fleet_server_host_callout = require("./missing_fleet_server_host_callout");
var _hooks2 = require("./hooks");
var _agent_policy_selection = require("./agent_policy_selection");
Object.keys(_agent_policy_selection).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _agent_policy_selection[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _agent_policy_selection[key];
    }
  });
});
var _agent_policy_select_create = require("./agent_policy_select_create");
Object.keys(_agent_policy_select_create).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _agent_policy_select_create[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _agent_policy_select_create[key];
    }
  });
});
var _steps = require("./steps");
Object.keys(_steps).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _steps[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _steps[key];
    }
  });
});
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentEnrollmentFlyout = ({
  onClose,
  agentPolicy,
  defaultMode = 'managed',
  isIntegrationFlow,
  installedPackagePolicy
}) => {
  const findPolicyById = (policies, id) => {
    if (!id) return undefined;
    return policies.find(p => p.id === id);
  };
  const fleetStatus = (0, _hooks.useFleetStatus)();
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const [selectedPolicyId, setSelectedPolicyId] = (0, _react.useState)(agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id);
  const [isFleetServerPolicySelected, setIsFleetServerPolicySelected] = (0, _react.useState)(false);
  const [selectedApiKeyId, setSelectedAPIKeyId] = (0, _react.useState)();
  const [mode, setMode] = (0, _react.useState)(defaultMode);
  const [selectionType, setSelectionType] = (0, _react.useState)();
  const {
    agentPolicies,
    isLoadingInitialAgentPolicies,
    isLoadingAgentPolicies,
    refreshAgentPolicies
  } = (0, _hooks.useAgentEnrollmentFlyoutData)();
  const {
    agentPolicyWithPackagePolicies
  } = (0, _hooks2.useAgentPolicyWithPackagePolicies)(selectedPolicyId);
  const {
    fleetServerHosts,
    fleetProxy,
    isLoadingInitialRequest
  } = (0, _hooks.useFleetServerHostsForPolicy)(agentPolicyWithPackagePolicies);
  const selectedPolicy = agentPolicyWithPackagePolicies ? agentPolicyWithPackagePolicies : findPolicyById(agentPolicies, selectedPolicyId);
  const hasNoFleetServerHost = fleetStatus.isReady && fleetServerHosts.length === 0;
  (0, _react.useEffect)(() => {
    if (selectedPolicy) {
      if (selectedPolicy.package_policies.some(packagePolicy => {
        var _packagePolicy$packag;
        return ((_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name) === _constants.FLEET_SERVER_PACKAGE;
      })) {
        setIsFleetServerPolicySelected(true);
      } else {
        setIsFleetServerPolicySelected(false);
      }
    }
  }, [selectedPolicy, isFleetServerPolicySelected]);
  const {
    isK8s
  } = (0, _hooks2.useIsK8sPolicy)(selectedPolicy ? selectedPolicy : undefined);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "agentEnrollmentFlyout",
    onClose: onClose,
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "aria-labelledby": "FleetAgentEnrollmentFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "FleetAgentEnrollmentFlyoutTitle"
  }, isFleetServerPolicySelected ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.flyoutFleetServerTitle",
    defaultMessage: "Add Fleet Server"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.flyoutTitle",
    defaultMessage: "Add agent"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), isFleetServerPolicySelected ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.instructionstFleetServer",
    defaultMessage: "A Fleet Server is required before you can enroll agents with Fleet. Follow the instructions below to set up a Fleet Server. For more information, see the {userGuideLink}",
    values: {
      userGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.fleetServerAddFleetServer,
        external: true,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentEnrollment.setupGuideLink",
        defaultMessage: "Fleet and Elastic Agent Guide"
      }))
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.agentDescription",
    defaultMessage: "Add Elastic Agents to your hosts to collect data and send it to the Elastic Stack."
  })), selectionType === 'tabs' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    style: {
      marginBottom: '-25px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": "managedTab",
    isSelected: mode === 'managed',
    onClick: () => setMode('managed')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.enrollFleetTabLabel",
    defaultMessage: "Enroll in Fleet"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": "standaloneTab",
    isSelected: mode === 'standalone',
    onClick: () => setMode('standalone')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.enrollStandaloneTabLabel",
    defaultMessage: "Run standalone"
  })))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: hasNoFleetServerHost && !isLoadingInitialRequest && mode === 'managed' ? /*#__PURE__*/_react.default.createElement(_missing_fleet_server_host_callout.MissingFleetServerHostCallout, null) : undefined
  }, isLoadingInitialAgentPolicies ? /*#__PURE__*/_react.default.createElement(_.Loading, {
    size: "l"
  }) : /*#__PURE__*/_react.default.createElement(_instructions.Instructions, {
    fleetServerHosts: fleetServerHosts,
    fleetProxy: fleetProxy,
    setSelectedPolicyId: setSelectedPolicyId,
    agentPolicy: agentPolicy,
    selectedPolicy: selectedPolicy,
    agentPolicies: agentPolicies,
    isFleetServerPolicySelected: isFleetServerPolicySelected,
    isK8s: isK8s,
    refreshAgentPolicies: refreshAgentPolicies,
    isLoadingAgentPolicies: isLoadingAgentPolicies,
    mode: mode,
    setMode: setMode,
    selectionType: selectionType,
    setSelectionType: setSelectionType,
    isIntegrationFlow: isIntegrationFlow,
    selectedApiKeyId: selectedApiKeyId,
    setSelectedAPIKeyId: setSelectedAPIKeyId,
    onClickViewAgents: onClose,
    installedPackagePolicy: installedPackagePolicy
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.closeFlyoutButtonLabel",
    defaultMessage: "Close"
  }))))));
};
exports.AgentEnrollmentFlyout = AgentEnrollmentFlyout;