"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudFormationInstructions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCloudFormationUrl = (templateURL, enrollmentToken, fleetUrl, kibanaVersion) => {
  const cloudFormationUrl = templateURL.replace('FLEET_ENROLLMENT_TOKEN', enrollmentToken).replace('FLEET_URL', fleetUrl).replace('KIBANA_VERSION', kibanaVersion);
  return new URL(cloudFormationUrl).toString();
};
const CloudFormationInstructions = ({
  enrollmentAPIKey,
  cloudFormationTemplateUrl
}) => {
  var _data$item$fleet_serv;
  const {
    data,
    isLoading
  } = (0, _hooks.useGetSettings)();
  const kibanaVersion = (0, _hooks.useKibanaVersion)();

  // Default fleet server host
  const fleetServerHost = data === null || data === void 0 ? void 0 : (_data$item$fleet_serv = data.item.fleet_server_hosts) === null || _data$item$fleet_serv === void 0 ? void 0 : _data$item$fleet_serv[0];
  if (!isLoading && !fleetServerHost) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudFormation.noFleetServer', {
        defaultMessage: 'Fleet Server host not found'
      }),
      color: "danger",
      iconType: "error"
    }));
  }
  if (!enrollmentAPIKey) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudFormation.noApiKey', {
        defaultMessage: 'Enrollment token not found'
      }),
      color: "danger",
      iconType: "error"
    }));
  }
  const cloudFormationUrl = createCloudFormationUrl(cloudFormationTemplateUrl, enrollmentAPIKey, fleetServerHost || '', kibanaVersion);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    size: "m",
    isLoading: isLoading,
    contentAriaLabel: _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudFormation.loadingAriaLabel', {
      defaultMessage: 'Loading CloudFormation instructions'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudFormation.callout', {
      defaultMessage: 'Sign in to your AWS cloud provider account, and switch to the region that you want to scan, then click Launch CloudFormation.'
    }),
    color: "warning",
    iconType: "warning"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    target: "_blank",
    iconSide: "right",
    iconType: "popout",
    href: cloudFormationUrl
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.cloudFormation.launchButton",
    defaultMessage: "Launch CloudFormation"
  })));
};
exports.CloudFormationInstructions = CloudFormationInstructions;