"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddAgentHelpPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = require("styled-components");
var _hooks = require("../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddAgentHelpPopover = ({
  button,
  isOpen,
  offset,
  closePopover
}) => {
  const {
    docLinks,
    uiSettings
  } = (0, _hooks.useStartServices)();
  const theme = (0, _styledComponents.useTheme)();
  const optionalProps = {};
  const hideAnnouncements = (0, _react.useMemo)(() => uiSettings.get('hideAnnouncements'), [uiSettings]);
  if (offset !== undefined) {
    optionalProps.offset = offset; // offset being present in props sets it to 0 so only add if specified
  }

  return hideAnnouncements ? button : /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, (0, _extends2.default)({}, optionalProps, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      style: {
        width: 302
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.addAgentHelpPopover.popoverBody",
      defaultMessage: "For integrations to work successfully, add {elasticAgent} to your host to collect data and send it to Elastic Stack. {learnMoreLink}",
      values: {
        elasticAgent: /*#__PURE__*/_react.default.createElement("strong", null, "Elastic Agent"),
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          external: true,
          href: docLinks.links.fleet.elasticAgent
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.addAgentHelpPopover.documentationLink",
          defaultMessage: "Learn more about Elastic Agent."
        }))
      }
    })),
    zIndex: theme.eui.euiZLevel1 - 1 // put popover behind any modals that happen to be open
    ,
    isStepOpen: isOpen,
    minWidth: 300,
    onFinish: () => {},
    step: 1,
    stepsTotal: 1,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.addAgentHelpPopover.title",
      defaultMessage: "Don't forget to add the agent to your host"
    }),
    anchorPosition: "downCenter",
    subtitle: null,
    "data-test-subj": "addAgentHelpPopover",
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        closePopover();
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.addAgentHelpPopover.footActionButton",
      defaultMessage: "Got it"
    }))
  }), button);
};
exports.AddAgentHelpPopover = AddAgentHelpPopover;