"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallButton = InstallButton;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _confirm_package_install = require("./confirm_package_install");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InstallButton(props) {
  const {
    name,
    numOfAssets,
    title,
    version
  } = props;
  const canInstallPackages = (0, _hooks.useAuthz)().integrations.installPackages;
  const installPackage = (0, _hooks.useInstallPackage)();
  const getPackageInstallStatus = (0, _hooks.useGetPackageInstallStatus)();
  const {
    status: installationStatus
  } = getPackageInstallStatus(name);
  const isInstalling = installationStatus === _types.InstallStatus.installing;
  const [isInstallModalVisible, setIsInstallModalVisible] = (0, _react.useState)(false);
  const toggleInstallModal = (0, _react.useCallback)(() => {
    setIsInstallModalVisible(!isInstallModalVisible);
  }, [isInstallModalVisible]);
  const handleClickInstall = (0, _react.useCallback)(() => {
    installPackage({
      name,
      version,
      title
    });
    toggleInstallModal();
  }, [installPackage, name, title, toggleInstallModal, version]);
  const installModal = /*#__PURE__*/_react.default.createElement(_confirm_package_install.ConfirmPackageInstall, {
    numOfAssets: numOfAssets,
    packageName: title,
    onCancel: toggleInstallModal,
    onConfirm: handleClickInstall
  });
  return canInstallPackages ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: 'importAction',
    isLoading: isInstalling,
    onClick: toggleInstallModal,
    "data-test-subj": "installAssetsButton"
  }, isInstalling ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.installPackage.installingPackageButtonLabel",
    defaultMessage: "Installing {title} assets",
    values: {
      title
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.installPackage.installPackageButtonLabel",
    defaultMessage: "Install {title} assets",
    values: {
      title
    }
  })), isInstallModalVisible && installModal) : null;
}