"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyAgentsCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../../../../../../components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddAgentButton = ({
  onAddAgent
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  iconType: "plusInCircle",
  "data-test-subj": "addAgentButton",
  onClick: onAddAgent,
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.epm.packageDetails.integrationList.addAgent",
  defaultMessage: "Add agent"
}));
const AddAgentButtonWithPopover = ({
  onAddAgent
}) => {
  const [isHelpOpen, setIsHelpOpen] = (0, _react.useState)(true);
  const onAddAgentCloseHelp = () => {
    setIsHelpOpen(false);
    onAddAgent();
  };
  const button = /*#__PURE__*/_react.default.createElement(AddAgentButton, {
    onAddAgent: onAddAgentCloseHelp
  });
  return /*#__PURE__*/_react.default.createElement(_components.AddAgentHelpPopover, {
    button: button,
    isOpen: isHelpOpen,
    closePopover: () => setIsHelpOpen(false)
  });
};
const PackagePolicyAgentsCell = ({
  agentPolicy,
  agentCount = 0,
  onAddAgent,
  hasHelpPopover = false
}) => {
  if (agentCount > 0 || agentPolicy.is_managed) {
    return /*#__PURE__*/_react.default.createElement(_components.LinkedAgentCount, {
      count: agentCount,
      agentPolicyId: agentPolicy.id,
      className: "eui-textTruncate"
    });
  }
  if (!hasHelpPopover) {
    return /*#__PURE__*/_react.default.createElement(AddAgentButton, {
      onAddAgent: onAddAgent
    });
  }
  return /*#__PURE__*/_react.default.createElement(AddAgentButtonWithPopover, {
    onAddAgent: onAddAgent
  });
};
exports.PackagePolicyAgentsCell = PackagePolicyAgentsCell;