"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../../../../../../common/services");
var _hooks = require("../../../../../../../hooks");
var _services2 = require("../../../../../../../services");
var _screenshots = require("./screenshots");
var _readme = require("./readme");
var _details = require("./details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LeftColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  /* 🤢🤷 https://www.styled-components.com/docs/faqs#how-can-i-override-styles-with-higher-specificity */
  &&& {
    margin-top: 77px;
  }
`;
const UnverifiedCallout = () => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.epm.verificationWarningCalloutTitle', {
      defaultMessage: 'Integration not verified'
    }),
    iconType: "warning",
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.verificationWarningCalloutIntroText",
    defaultMessage: "This integration contains an unsigned package of unknown authenticity. Learn more about {learnMoreLink}.",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        external: true,
        href: docLinks.links.fleet.packageSignatures
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.verificationWarningCalloutLearnMoreLink",
        defaultMessage: "package signatures"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};
const PrereleaseCallout = ({
  packageName,
  packageTitle,
  latestGAVersion
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const overviewPathLatestGA = getHref('integration_details_overview', {
    pkgkey: `${packageName}-${latestGAVersion}`
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "prereleaseCallout",
    title: _i18n.i18n.translate('xpack.fleet.epm.prereleaseWarningCalloutTitle', {
      defaultMessage: 'This is a pre-release version of {packageTitle} integration.',
      values: {
        packageTitle
      }
    }),
    iconType: "iInCircle",
    color: "warning"
  }, latestGAVersion && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: overviewPathLatestGA,
    color: "warning",
    "data-test-subj": "switchToGABtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.prereleaseWarningCalloutSwitchToGAButton",
    defaultMessage: "Switch to latest GA version"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};
const OverviewPage = /*#__PURE__*/(0, _react.memo)(({
  packageInfo,
  integrationInfo,
  latestGAVersion
}) => {
  const screenshots = (0, _react.useMemo)(() => (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.screenshots) || packageInfo.screenshots || [], [integrationInfo, packageInfo.screenshots]);
  const {
    packageVerificationKeyId
  } = (0, _hooks.useGetPackageVerificationKeyId)();
  const isUnverified = (0, _services2.isPackageUnverified)(packageInfo, packageVerificationKeyId);
  const isPrerelease = (0, _services.isPackagePrerelease)(packageInfo.version);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(LeftColumn, {
    grow: 2
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 9,
    className: "eui-textBreakWord"
  }, isUnverified && /*#__PURE__*/_react.default.createElement(UnverifiedCallout, null), isPrerelease && /*#__PURE__*/_react.default.createElement(PrereleaseCallout, {
    packageName: packageInfo.name,
    packageTitle: packageInfo.title,
    latestGAVersion: latestGAVersion
  }), packageInfo.readme ? /*#__PURE__*/_react.default.createElement(_readme.Readme, {
    readmePath: integrationInfo && (0, _services.isIntegrationPolicyTemplate)(integrationInfo) && integrationInfo !== null && integrationInfo !== void 0 && integrationInfo.readme ? integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.readme : packageInfo.readme,
    packageName: packageInfo.name,
    version: packageInfo.version
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    alignItems: "flexStart"
  }, screenshots.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_screenshots.Screenshots, {
    images: screenshots,
    packageName: packageInfo.name,
    version: packageInfo.version
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_details.Details, {
    packageInfo: packageInfo
  })))));
});
exports.OverviewPage = OverviewPage;