"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoticeModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoticeModal = ({
  noticePath,
  onClose
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [notice, setNotice] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    async function fetchData() {
      try {
        const {
          data
        } = await (0, _hooks.sendGetFileByPath)(noticePath);
        setNotice(data || '');
      } catch (err) {
        notifications.toasts.addError(err, {
          title: _i18n.i18n.translate('xpack.fleet.epm.errorLoadingNotice', {
            defaultMessage: 'Error loading NOTICE.txt'
          })
        });
      }
    }
    fetchData();
  }, [noticePath, notifications]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    maxWidth: true,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, "NOTICE.txt")), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: 360
  }, notice ? notice :
  /*#__PURE__*/
  // Simulate a long notice while loading
  _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 5
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 6
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.noticeModalCloseBtn",
    defaultMessage: "Close"
  }))));
};
exports.NoticeModal = NoticeModal;