"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.markdownRenderers = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** prevents links to the new pages from accessing `window.opener` */
const REL_NOOPENER = 'noopener';

/** prevents search engine manipulation by noting the linked document is not trusted or endorsed by us */
const REL_NOFOLLOW = 'nofollow';

/** prevents the browser from sending the current address as referrer via the Referer HTTP header */
const REL_NOREFERRER = 'noreferrer';

// Maps deprecated code block languages to supported ones in prism.js
const CODE_LANGUAGE_OVERRIDES = {
  $json: 'json',
  $yml: 'yml'
};
const markdownRenderers = {
  table: ({
    children
  }) => /*#__PURE__*/_react.default.createElement("table", {
    className: "euiTable euiTable--responsive"
  }, children),
  tr: ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, null, children),
  th: ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, children),
  td: ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, children),
  // the headings used in markdown don't match our page so mapping them to the appropriate one
  h1: ({
    children
  }) => /*#__PURE__*/_react.default.createElement("h3", null, children),
  h2: ({
    children
  }) => /*#__PURE__*/_react.default.createElement("h4", null, children),
  h3: ({
    children
  }) => /*#__PURE__*/_react.default.createElement("h5", null, children),
  h4: ({
    children
  }) => /*#__PURE__*/_react.default.createElement("h6", null, children),
  h5: ({
    children
  }) => /*#__PURE__*/_react.default.createElement("h6", null, children),
  h6: ({
    children
  }) => /*#__PURE__*/_react.default.createElement("h6", null, children),
  link: ({
    children,
    href
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: href,
    target: "_blank",
    rel: `${REL_NOOPENER} ${REL_NOFOLLOW} ${REL_NOREFERRER}`
  }, children),
  code: ({
    className,
    children,
    inline
  }) => {
    var _exec$, _exec;
    let parsedLang = (_exec$ = (_exec = /language-(\w+)/.exec(className || '')) === null || _exec === void 0 ? void 0 : _exec[1]) !== null && _exec$ !== void 0 ? _exec$ : '';

    // Some integrations export code block content that includes language tags that have since
    // been removed or deprecated in `prism.js`, the upstream depedency that handles syntax highlighting
    // in EuiCodeBlock components
    const languageOverride = parsedLang ? CODE_LANGUAGE_OVERRIDES[parsedLang] : undefined;
    if (languageOverride) {
      parsedLang = languageOverride;
    }
    if (inline) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, children);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: parsedLang,
      isCopyable: true
    }, children);
  }
};
exports.markdownRenderers = markdownRenderers;