"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentationPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../../../hooks");
var _services = require("../../../../../../../../common/services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentationPage = ({
  packageInfo,
  integration
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.apiReference.description",
    defaultMessage: "This documents all the inputs, streams, and variables available to use this integration programmatically via the Fleet Kibana API. {learnMore}",
    values: {
      learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.api
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.learnMoreLink",
        defaultMessage: "Learn more"
      }))
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(PackageVars, {
    vars: packageInfo.vars
  }), /*#__PURE__*/_react.default.createElement(Inputs, {
    packageInfo: packageInfo,
    integration: integration
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, content));
};
exports.DocumentationPage = DocumentationPage;
const StreamsSection = ({
  streams
}) => {
  if (streams.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.apiReference.streamsTitle",
    defaultMessage: "Streams"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), streams.map(dataStream => /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    key: dataStream.data_stream.type + dataStream.data_stream.dataset,
    id: dataStream.data_stream.type + dataStream.data_stream.dataset,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, dataStream.data_stream.dataset), "(", dataStream.title, ")"),
    initialIsOpen: false,
    paddingSize: 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, dataStream.description), dataStream.vars ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(VarsTable, {
    vars: dataStream.vars
  })) : null)));
};
const Inputs = ({
  packageInfo,
  integration
}) => {
  var _inputs$map;
  const inputs = (0, _react.useMemo)(() => {
    var _packageInfo$policy_t;
    return (_packageInfo$policy_t = packageInfo.policy_templates) === null || _packageInfo$policy_t === void 0 ? void 0 : _packageInfo$policy_t.reduce((acc, policyTemplate) => {
      if (integration && policyTemplate.name !== integration) {
        return acc;
      }
      if ('inputs' in policyTemplate && policyTemplate.inputs) {
        return [...acc, ...policyTemplate.inputs.map(input => ({
          key: `${policyTemplate.name}-${input.type}`,
          ...input,
          streams: (0, _services.getStreamsForInputType)(input.type, packageInfo, [])
        }))];
      }
      return acc;
    }, []);
  }, [packageInfo, integration]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.apiReference.inputsTitle",
    defaultMessage: "Inputs"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), (_inputs$map = inputs === null || inputs === void 0 ? void 0 : inputs.map(input => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      key: input.key,
      id: input.key,
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, input.key), "(", input.title, ")"),
      initialIsOpen: false,
      paddingSize: 'm'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, input.description), input.vars ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(VarsTable, {
      vars: input.vars
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(StreamsSection, {
      streams: input.streams
    }));
  })) !== null && _inputs$map !== void 0 ? _inputs$map : null);
};
const PackageVars = ({
  vars
}) => {
  if (!vars) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.apiReference.globalVariablesTitle",
    defaultMessage: "Package variables"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(VarsTable, {
    vars: vars
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const VarsTable = ({
  vars
}) => {
  const columns = (0, _react.useMemo)(() => {
    return [{
      field: 'name',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.columnKeyName",
        defaultMessage: "Key"
      }),
      render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, name)
    }, {
      field: 'title',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.columnTitleName",
        defaultMessage: "Title"
      })
    }, {
      field: 'type',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.columnTypeName",
        defaultMessage: "Type"
      })
    }, {
      field: 'required',
      width: '70px',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.columnRequiredName",
        defaultMessage: "Required"
      })
    }, {
      field: 'multi',
      width: '70px',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.columnMultidName",
        defaultMessage: "Multi"
      })
    }];
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.apiReference.variableTableTitle",
    defaultMessage: "Variables"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: vars
  }));
};