"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultLayout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _ = require(".");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DefaultLayout = /*#__PURE__*/(0, _react.memo)(({
  section,
  children,
  notificationsBySection
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const tabs = [{
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.appNavigation.integrationsAllLinkText",
      defaultMessage: "Browse integrations"
    }),
    section: 'browse',
    href: getHref('integrations_all')
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.appNavigation.integrationsInstalledLinkText",
      defaultMessage: "Installed integrations"
    }),
    section: 'manage',
    href: getHref('integrations_installed')
  }];
  return /*#__PURE__*/_react.default.createElement(_.WithHeaderLayout, {
    leftColumn: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrationsHeaderTitle",
      defaultMessage: "Integrations"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.pageSubtitle",
      defaultMessage: "Choose an integration to start collecting and analyzing your data."
    }))))),
    tabs: tabs.map(tab => {
      const notificationCount = notificationsBySection === null || notificationsBySection === void 0 ? void 0 : notificationsBySection[tab.section];
      return {
        name: tab.name,
        append: notificationCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
          className: "eui-alignCenter",
          size: "m"
        }, notificationCount) : undefined,
        href: tab.href,
        isSelected: section === tab.section
      };
    })
  }, children);
});
exports.DefaultLayout = DefaultLayout;