"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchIdField = exports.fieldsToSearch = void 0;
exports.useLocalSearch = useLocalSearch;
var _jsSearch = require("js-search");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchIdField = 'id';
exports.searchIdField = searchIdField;
const fieldsToSearch = ['name', 'title', 'description'];
exports.fieldsToSearch = fieldsToSearch;
function useLocalSearch(packageList) {
  const localSearchRef = (0, _react.useRef)(new _jsSearch.Search(searchIdField));
  const localSearch = new _jsSearch.Search(searchIdField);
  localSearch.indexStrategy = new _jsSearch.PrefixIndexStrategy();
  fieldsToSearch.forEach(field => localSearch.addIndex(field));
  localSearch.addDocuments(packageList);
  localSearchRef.current = localSearch;
  return localSearchRef;
}