"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeploymentDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _hooks = require("../../hooks");
var _deployment_details = require("./deployment_details.component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeploymentDetails = () => {
  var _share$url$locators$g;
  const {
    share,
    cloud,
    docLinks
  } = (0, _hooks.useStartServices)();

  // If the cloud plugin isn't enabled, we can't display the flyout.
  if (!cloud) {
    return null;
  }
  const {
    isCloudEnabled,
    cloudId
  } = cloud;

  // If cloud isn't enabled or we don't have a cloudId we can't display the flyout.
  if (!isCloudEnabled || !cloudId) {
    return null;
  }
  const managementUrl = (_share$url$locators$g = share.url.locators.get('MANAGEMENT_APP_LOCATOR')) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.useUrl({
    sectionId: 'security',
    appId: 'api_keys'
  });
  const learnMoreUrl = docLinks.links.fleet.apiKeysLearnMore;
  return /*#__PURE__*/_react.default.createElement(_deployment_details.DeploymentDetails, {
    cloudId,
    managementUrl,
    learnMoreUrl
  });
};
exports.DeploymentDetails = DeploymentDetails;