"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsApp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _hooks = require("../../hooks");
var _constants = require("../../constants");
var _layouts = require("../../layouts");
var _components = require("../../components");
var _settings_page = require("./components/settings_page");
var _use_confirm_modal = require("./hooks/use_confirm_modal");
var _fleet_server_hosts_flyout = require("./components/fleet_server_hosts_flyout");
var _edit_output_flyout = require("./components/edit_output_flyout");
var _hooks2 = require("./hooks");
var _download_source_flyout = require("./components/download_source_flyout");
var _use_delete_download_source = require("./components/download_source_flyout/use_delete_download_source");
var _edit_fleet_proxy_flyout = require("./components/edit_fleet_proxy_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSettingsAppData() {
  const outputs = (0, _hooks.useGetOutputs)();
  const fleetServerHosts = (0, _hooks.useGetFleetServerHosts)();
  const downloadSources = (0, _hooks.useGetDownloadSources)();
  const proxies = (0, _hooks.useGetFleetProxies)();
  return {
    outputs,
    fleetServerHosts,
    downloadSources,
    proxies
  };
}
const SettingsApp = (0, _use_confirm_modal.withConfirmModalProvider)(() => {
  var _outputs$data, _fleetServerHosts$dat, _downloadSources$data, _proxies$data;
  (0, _hooks.useBreadcrumbs)('settings');
  const history = (0, _reactRouterDom.useHistory)();
  const flyoutContext = (0, _hooks.useFlyoutContext)();
  const {
    outputs,
    fleetServerHosts,
    downloadSources,
    proxies
  } = useSettingsAppData();
  const {
    deleteOutput
  } = (0, _hooks2.useDeleteOutput)(outputs.resendRequest);
  const {
    deleteDownloadSource
  } = (0, _use_delete_download_source.useDeleteDownloadSource)(downloadSources.resendRequest);
  const {
    deleteFleetServerHost
  } = (0, _hooks2.useDeleteFleetServerHost)(fleetServerHosts.resendRequest);
  const {
    deleteFleetProxy
  } = (0, _hooks2.useDeleteProxy)(proxies.resendRequest);
  const resendOutputRequest = outputs.resendRequest;
  const resendDownloadSourceRequest = downloadSources.resendRequest;
  const resendFleetServerHostsRequest = fleetServerHosts.resendRequest;
  const resendProxiesRequest = proxies.resendRequest;
  const onCloseCallback = (0, _react.useCallback)(() => {
    flyoutContext.closeFleetServerFlyout();
    resendOutputRequest();
    resendDownloadSourceRequest();
    resendFleetServerHostsRequest();
    resendProxiesRequest();
    history.replace(_constants.pagePathGetters.settings()[1]);
  }, [flyoutContext, resendOutputRequest, resendDownloadSourceRequest, resendFleetServerHostsRequest, resendProxiesRequest, history]);
  if (outputs.isLoading && outputs.isInitialRequest || !((_outputs$data = outputs.data) !== null && _outputs$data !== void 0 && _outputs$data.items) || fleetServerHosts.isLoading && fleetServerHosts.isInitialRequest || !((_fleetServerHosts$dat = fleetServerHosts.data) !== null && _fleetServerHosts$dat !== void 0 && _fleetServerHosts$dat.items) || downloadSources.isLoading && downloadSources.isInitialRequest || !((_downloadSources$data = downloadSources.data) !== null && _downloadSources$data !== void 0 && _downloadSources$data.items) || proxies.isLoading && proxies.isInitialRequest || !((_proxies$data = proxies.data) !== null && _proxies$data !== void 0 && _proxies$data.items)) {
    return /*#__PURE__*/_react.default.createElement(_layouts.DefaultLayout, {
      section: "settings"
    }, /*#__PURE__*/_react.default.createElement(_components.Loading, null));
  }
  return /*#__PURE__*/_react.default.createElement(_layouts.DefaultLayout, {
    section: "settings"
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_edit_fleet_server_hosts
  }, route => {
    var _fleetServerHosts$dat2, _proxies$data$items, _proxies$data2;
    const fleetServerHost = (_fleetServerHosts$dat2 = fleetServerHosts.data) === null || _fleetServerHosts$dat2 === void 0 ? void 0 : _fleetServerHosts$dat2.items.find(o => route.match.params.itemId === o.id);
    if (!fleetServerHost) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: _constants.FLEET_ROUTING_PATHS.settings
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_fleet_server_hosts_flyout.FleetServerHostsFlyout, {
      proxies: (_proxies$data$items = (_proxies$data2 = proxies.data) === null || _proxies$data2 === void 0 ? void 0 : _proxies$data2.items) !== null && _proxies$data$items !== void 0 ? _proxies$data$items : [],
      onClose: onCloseCallback,
      fleetServerHost: fleetServerHost
    }));
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_create_fleet_server_hosts
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components.FleetServerFlyout, {
    onClose: onCloseCallback
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_create_outputs
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_edit_output_flyout.EditOutputFlyout, {
    proxies: proxies.data.items,
    onClose: onCloseCallback
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_create_fleet_proxy
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_edit_fleet_proxy_flyout.FleetProxyFlyout, {
    onClose: onCloseCallback
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_edit_fleet_proxy
  }, route => {
    var _proxies$data3;
    const fleetProxy = (_proxies$data3 = proxies.data) === null || _proxies$data3 === void 0 ? void 0 : _proxies$data3.items.find(item => route.match.params.itemId === item.id);
    if (!fleetProxy) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: _constants.FLEET_ROUTING_PATHS.settings
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_edit_fleet_proxy_flyout.FleetProxyFlyout, {
      onClose: onCloseCallback,
      fleetProxy: fleetProxy
    }));
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_edit_outputs
  }, route => {
    var _outputs$data2, _proxies$data$items2, _proxies$data4;
    const output = (_outputs$data2 = outputs.data) === null || _outputs$data2 === void 0 ? void 0 : _outputs$data2.items.find(o => route.match.params.outputId === o.id);
    if (!output) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: _constants.FLEET_ROUTING_PATHS.settings
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_edit_output_flyout.EditOutputFlyout, {
      proxies: (_proxies$data$items2 = (_proxies$data4 = proxies.data) === null || _proxies$data4 === void 0 ? void 0 : _proxies$data4.items) !== null && _proxies$data$items2 !== void 0 ? _proxies$data$items2 : [],
      onClose: onCloseCallback,
      output: output
    }));
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_create_download_sources
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_download_source_flyout.EditDownloadSourceFlyout, {
    onClose: onCloseCallback
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings_edit_download_sources
  }, route => {
    var _downloadSources$data2;
    const downloadSource = (_downloadSources$data2 = downloadSources.data) === null || _downloadSources$data2 === void 0 ? void 0 : _downloadSources$data2.items.find(o => route.match.params.downloadSourceId === o.id);
    if (!downloadSource) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: _constants.FLEET_ROUTING_PATHS.settings
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_download_source_flyout.EditDownloadSourceFlyout, {
      onClose: onCloseCallback,
      downloadSource: downloadSource
    }));
  }))), /*#__PURE__*/_react.default.createElement(_settings_page.SettingsPage, {
    deleteFleetProxy: deleteFleetProxy,
    proxies: proxies.data.items,
    outputs: outputs.data.items,
    fleetServerHosts: fleetServerHosts.data.items,
    deleteOutput: deleteOutput,
    deleteFleetServerHost: deleteFleetServerHost,
    downloadSources: downloadSources.data.items,
    deleteDownloadSource: deleteDownloadSource
  }));
});
exports.SettingsApp = SettingsApp;