"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteFleetServerHost = useDeleteFleetServerHost;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
var _use_confirm_modal = require("./use_confirm_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmTitle = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.deleteFleetServerHosts.confirmModalTitle",
  defaultMessage: "Delete and deploy changes?"
});
const ConfirmDescription = ({}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.deleteFleetServerHosts.confirmModalText",
  defaultMessage: "This action will change agent policies currently enrolled in this Fleet Server, to instead enroll in your default Fleet server. Are you sure you wish to continue?"
});
function useDeleteFleetServerHost(onSuccess) {
  const {
    confirm
  } = (0, _use_confirm_modal.useConfirmModal)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const deleteFleetServerHost = (0, _react.useCallback)(async fleetServerHost => {
    try {
      const isConfirmed = await confirm( /*#__PURE__*/_react.default.createElement(ConfirmTitle, null), /*#__PURE__*/_react.default.createElement(ConfirmDescription, null), {
        buttonColor: 'danger',
        confirmButtonText: _i18n.i18n.translate('xpack.fleet.settings.deleteFleetServerHosts.confirmButtonLabel', {
          defaultMessage: 'Delete and deploy changes'
        })
      });
      if (!isConfirmed) {
        return;
      }
      const res = await (0, _hooks.sendDeleteFleetServerHost)(fleetServerHost.id);
      if (res.error) {
        throw res.error;
      }
      onSuccess();
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.settings.deleteFleetServerHosts.errorToastTitle', {
          defaultMessage: 'Error deleting Fleet Server hosts'
        })
      });
    }
  }, [confirm, notifications.toasts, onSuccess]);
  return {
    deleteFleetServerHost
  };
}