"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmModalProvider = void 0;
exports.useConfirmModal = useConfirmModal;
exports.withConfirmModalProvider = withConfirmModalProvider;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ModalContext = /*#__PURE__*/_react.default.createContext(null);
function useConfirmModal() {
  const context = (0, _react.useContext)(ModalContext);
  const confirm = (0, _react.useCallback)(async (title, description, options) => {
    if (context === null) {
      throw new Error('Context need to be provided to use useConfirmModal');
    }
    return new Promise(resolve => {
      context.showModal({
        title,
        description,
        onConfirm: () => resolve(true),
        onCancel: () => resolve(false),
        options
      });
    });
  }, [context]);
  return {
    confirm
  };
}
function withConfirmModalProvider(WrappedComponent) {
  return props => /*#__PURE__*/_react.default.createElement(ConfirmModalProvider, null, /*#__PURE__*/_react.default.createElement(WrappedComponent, props));
}
const ConfirmModalProvider = ({
  children
}) => {
  var _modal$options, _modal$options$confir, _modal$options2;
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  const [modal, setModal] = (0, _react.useState)({
    onCancel: () => {},
    onConfirm: () => {}
  });
  const showModal = (0, _react.useCallback)(({
    title,
    description,
    onConfirm,
    onCancel,
    options
  }) => {
    setIsVisible(true);
    setModal({
      title,
      description,
      onConfirm: () => {
        setIsVisible(false);
        onConfirm();
      },
      onCancel: () => {
        setIsVisible(false);
        onCancel();
      },
      options
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(ModalContext.Provider, {
    value: {
      showModal
    }
  }, isVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: modal.title,
    buttonColor: (_modal$options = modal.options) === null || _modal$options === void 0 ? void 0 : _modal$options.buttonColor,
    onCancel: modal.onCancel,
    onConfirm: modal.onConfirm,
    cancelButtonText: _i18n.i18n.translate('xpack.fleet.settings.confirmModal.cancelButtonText', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: (_modal$options$confir = (_modal$options2 = modal.options) === null || _modal$options2 === void 0 ? void 0 : _modal$options2.confirmButtonText) !== null && _modal$options$confir !== void 0 ? _modal$options$confir : _i18n.i18n.translate('xpack.fleet.settings.confirmModal.confirmButtonText', {
      defaultMessage: 'Save and deploy'
    }),
    defaultFocusedButton: "confirm"
  }, modal.description)), children);
};
exports.ConfirmModalProvider = ConfirmModalProvider;