"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _fleet_server_hosts_section = require("./fleet_server_hosts_section");
var _output_section = require("./output_section");
var _agent_binary_section = require("./agent_binary_section");
var _fleet_proxies_section = require("./fleet_proxies_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SettingsPage = ({
  outputs,
  proxies,
  fleetServerHosts,
  deleteOutput,
  deleteFleetServerHost,
  downloadSources,
  deleteDownloadSource,
  deleteFleetProxy
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_fleet_server_hosts_section.FleetServerHostsSection, {
    fleetServerHosts: fleetServerHosts,
    deleteFleetServerHost: deleteFleetServerHost
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_output_section.OutputSection, {
    outputs: outputs,
    deleteOutput: deleteOutput
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_agent_binary_section.AgentBinarySection, {
    downloadSources: downloadSources,
    deleteDownloadSource: deleteDownloadSource
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_fleet_proxies_section.FleetProxiesSection, {
    proxies: proxies,
    deleteFleetProxy: deleteFleetProxy
  }));
};
exports.SettingsPage = SettingsPage;