"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFleetProxyForm = useFleetProxyForm;
exports.validateName = validateName;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsYaml = require("js-yaml");
var _hooks = require("../../../../hooks");
var _use_confirm_modal = require("../../hooks/use_confirm_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const URL_REGEX = /^(http)(s)?:\/\/[^\s$.?#].[^\s]*$/gm;
const ConfirmTitle = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.fleetProxyFlyout.confirmModalTitle",
  defaultMessage: "Save and deploy changes?"
});
const ConfirmDescription = ({}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.fleetProxyFlyout.confirmModalText",
  defaultMessage: "This action will update agent policies using that proxies. This action can not be undone. Are you sure you wish to continue?"
});
function validateUrl(value) {
  if (!value || value === '') {
    return [_i18n.i18n.translate('xpack.fleet.settings.fleetProxyFlyoutUrlRequired', {
      defaultMessage: 'URL is required'
    })];
  }
  if (!value.match(URL_REGEX)) {
    return [_i18n.i18n.translate('xpack.fleet.settings.fleetProxyFlyoutUrlError', {
      defaultMessage: 'Invalid URL'
    })];
  }
}
function validateProxyHeaders(value) {
  if (value && value !== '') {
    const res = (0, _jsYaml.safeLoad)(value);
    if (typeof res !== 'object' || Object.values(res).some(val => {
      const valType = typeof val;
      return valType !== 'string' && valType !== 'number' && valType !== 'boolean';
    })) {
      return [_i18n.i18n.translate('xpack.fleet.settings.fleetProxy.proxyHeadersErrorMessage', {
        defaultMessage: 'Proxy headers is not a valid key: value object.'
      })];
    }
  }
}
function validateName(value) {
  if (!value || value === '') {
    return [_i18n.i18n.translate('xpack.fleet.settings.fleetProxy.nameIsRequiredErrorMessage', {
      defaultMessage: 'Name is required'
    })];
  }
}
function useFleetProxyForm(fleetProxy, onSuccess) {
  var _fleetProxy$is_precon, _fleetProxy$name, _fleetProxy$url, _fleetProxy$certifica, _fleetProxy$certifica2, _fleetProxy$certifica3;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    confirm
  } = (0, _use_confirm_modal.useConfirmModal)();
  const isPreconfigured = (_fleetProxy$is_precon = fleetProxy === null || fleetProxy === void 0 ? void 0 : fleetProxy.is_preconfigured) !== null && _fleetProxy$is_precon !== void 0 ? _fleetProxy$is_precon : false;
  const nameInput = (0, _hooks.useInput)((_fleetProxy$name = fleetProxy === null || fleetProxy === void 0 ? void 0 : fleetProxy.name) !== null && _fleetProxy$name !== void 0 ? _fleetProxy$name : '', validateName, isPreconfigured);
  const urlInput = (0, _hooks.useInput)((_fleetProxy$url = fleetProxy === null || fleetProxy === void 0 ? void 0 : fleetProxy.url) !== null && _fleetProxy$url !== void 0 ? _fleetProxy$url : '', validateUrl, isPreconfigured);
  const proxyHeadersInput = (0, _hooks.useInput)(fleetProxy !== null && fleetProxy !== void 0 && fleetProxy.proxy_headers ? (0, _jsYaml.safeDump)(fleetProxy.proxy_headers) : '', validateProxyHeaders, isPreconfigured);
  const certificateAuthoritiesInput = (0, _hooks.useInput)((_fleetProxy$certifica = fleetProxy === null || fleetProxy === void 0 ? void 0 : fleetProxy.certificate_authorities) !== null && _fleetProxy$certifica !== void 0 ? _fleetProxy$certifica : '', () => undefined, isPreconfigured);
  const certificateInput = (0, _hooks.useInput)((_fleetProxy$certifica2 = fleetProxy === null || fleetProxy === void 0 ? void 0 : fleetProxy.certificate) !== null && _fleetProxy$certifica2 !== void 0 ? _fleetProxy$certifica2 : '', () => undefined, isPreconfigured);
  const certificateKeyInput = (0, _hooks.useInput)((_fleetProxy$certifica3 = fleetProxy === null || fleetProxy === void 0 ? void 0 : fleetProxy.certificate_key) !== null && _fleetProxy$certifica3 !== void 0 ? _fleetProxy$certifica3 : '', () => undefined, isPreconfigured);
  const inputs = (0, _react.useMemo)(() => ({
    nameInput,
    urlInput,
    proxyHeadersInput,
    certificateAuthoritiesInput,
    certificateInput,
    certificateKeyInput
  }), [nameInput, urlInput, proxyHeadersInput, certificateAuthoritiesInput, certificateInput, certificateKeyInput]);
  const validate = (0, _react.useCallback)(() => (0, _hooks.validateInputs)(inputs), [inputs]);
  const submit = (0, _react.useCallback)(async () => {
    try {
      if (!validate()) {
        return;
      }
      if (fleetProxy && !(await confirm( /*#__PURE__*/_react.default.createElement(ConfirmTitle, null), /*#__PURE__*/_react.default.createElement(ConfirmDescription, null)))) {
        return;
      }
      setIsLoading(true);
      const data = {
        name: nameInput.value,
        url: urlInput.value,
        proxy_headers: proxyHeadersInput.value === '' ? undefined : (0, _jsYaml.safeLoad)(proxyHeadersInput.value),
        certificate_authorities: certificateAuthoritiesInput.value,
        certificate: certificateInput.value,
        certificate_key: certificateKeyInput.value
      };
      if (fleetProxy) {
        const res = await (0, _hooks.sendPutFleetProxy)(fleetProxy.id, data);
        if (res.error) {
          throw res.error;
        }
      } else {
        const res = await (0, _hooks.sendPostFleetProxy)(data);
        if (res.error) {
          throw res.error;
        }
      }
      notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.settings.fleetProxyFlyout.successToastTitle', {
        defaultMessage: 'Fleet proxy saved'
      }));
      setIsLoading(false);
      await onSuccess();
    } catch (error) {
      setIsLoading(false);
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.settings.fleetProxyFlyout.errorToastTitle', {
          defaultMessage: 'An error happened while saving Fleet Server host'
        })
      });
    }
  }, [fleetProxy, nameInput.value, urlInput.value, proxyHeadersInput.value, certificateAuthoritiesInput.value, certificateInput.value, certificateKeyInput.value, validate, notifications, confirm, onSuccess]);
  const hasChanged = Object.values(inputs).some(input => input.hasChanged);
  const isDisabled = isLoading || !hasChanged || nameInput.props.isInvalid || urlInput.props.isInvalid;
  return {
    isLoading,
    isDisabled,
    submit,
    inputs
  };
}