"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AGENT_STATUSES = void 0;
exports.getColorForAgentStatus = getColorForAgentStatus;
exports.getLabelForAgentStatus = getLabelForAgentStatus;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const visColors = (0, _eui.euiPaletteColorBlindBehindText)();
const colorToHexMap = {
  // using variables as mentioned here https://elastic.github.io/eui/#/guidelines/getting-started
  default: _uiTheme.euiLightVars.euiColorLightShade,
  primary: visColors[1],
  success: visColors[0],
  accent: visColors[2],
  warning: visColors[5],
  danger: visColors[9],
  inactive: _uiTheme.euiLightVars.euiColorDarkShade,
  lightest: _uiTheme.euiLightVars.euiColorDisabled
};
const AGENT_STATUSES = ['healthy', 'unhealthy', 'updating', 'offline', 'inactive', 'unenrolled'];
exports.AGENT_STATUSES = AGENT_STATUSES;
function getColorForAgentStatus(agentStatus) {
  switch (agentStatus) {
    case 'healthy':
      return colorToHexMap.success;
    case 'offline':
      return colorToHexMap.default;
    case 'inactive':
      return colorToHexMap.inactive;
    case 'unhealthy':
      return colorToHexMap.warning;
    case 'updating':
      return colorToHexMap.primary;
    case 'unenrolled':
      return colorToHexMap.lightest;
    default:
      throw new Error(`Unsupported Agent status ${agentStatus}`);
  }
}
function getLabelForAgentStatus(agentStatus) {
  switch (agentStatus) {
    case 'healthy':
      return _i18n.i18n.translate('xpack.fleet.agentStatus.healthyLabel', {
        defaultMessage: 'Healthy'
      });
    case 'offline':
      return _i18n.i18n.translate('xpack.fleet.agentStatus.offlineLabel', {
        defaultMessage: 'Offline'
      });
    case 'inactive':
      return _i18n.i18n.translate('xpack.fleet.agentStatus.inactiveLabel', {
        defaultMessage: 'Inactive'
      });
    case 'unenrolled':
      return _i18n.i18n.translate('xpack.fleet.agentStatus.unenrolledLabel', {
        defaultMessage: 'Unenrolled'
      });
    case 'unhealthy':
      return _i18n.i18n.translate('xpack.fleet.agentStatus.unhealthyLabel', {
        defaultMessage: 'Unhealthy'
      });
    case 'updating':
      return _i18n.i18n.translate('xpack.fleet.agentStatus.updatingLabel', {
        defaultMessage: 'Updating'
      });
    default:
      throw new Error(`Unsupported Agent status ${agentStatus}`);
  }
}