"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentHealth = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _agent_status = require("../../../../../../common/services/agent_status");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Status = {
  Healthy: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "success"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.healthyStatusText",
    defaultMessage: "Healthy"
  })),
  Offline: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.offlineStatusText",
    defaultMessage: "Offline"
  })),
  Inactive: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: _uiTheme.euiLightVars.euiColorDarkShade
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.inactiveStatusText",
    defaultMessage: "Inactive"
  })),
  Unenrolled: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: _uiTheme.euiLightVars.euiColorDisabled
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.unenrolledStatusText",
    defaultMessage: "Unenrolled"
  })),
  Unhealthy: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.unhealthyStatusText",
    defaultMessage: "Unhealthy"
  })),
  Updating: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.updatingStatusText",
    defaultMessage: "Updating"
  }))
};
function getStatusComponent(status) {
  switch (status) {
    case 'error':
    case 'degraded':
      return Status.Unhealthy;
    case 'inactive':
      return Status.Inactive;
    case 'offline':
      return Status.Offline;
    case 'unenrolling':
    case 'enrolling':
    case 'updating':
      return Status.Updating;
    case 'unenrolled':
      return Status.Unenrolled;
    default:
      return Status.Healthy;
  }
}
const AgentHealth = ({
  agent,
  showOfflinePreviousStatus
}) => {
  const {
    last_checkin: lastCheckIn,
    last_checkin_message: lastCheckInMessage
  } = agent;
  const msLastCheckIn = new Date(lastCheckIn || 0).getTime();
  const lastCheckInMessageText = lastCheckInMessage ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.checkinMessageText",
    defaultMessage: "Last checkin message: {lastCheckinMessage}",
    values: {
      lastCheckinMessage: lastCheckInMessage
    }
  }) : null;
  const lastCheckinText = msLastCheckIn ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.checkInTooltipText",
    defaultMessage: "Last checked in {lastCheckIn}",
    values: {
      lastCheckIn: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
        value: msLastCheckIn
      })
    }
  })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.noCheckInTooltipText",
    defaultMessage: "Never checked in"
  });
  const previousToOfflineStatus = (0, _react.useMemo)(() => {
    if (!showOfflinePreviousStatus || agent.status !== 'offline') {
      return;
    }
    return (0, _agent_status.getPreviousAgentStatusForOfflineAgents)(agent);
  }, [showOfflinePreviousStatus, agent]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, lastCheckinText), /*#__PURE__*/_react.default.createElement("p", null, lastCheckInMessageText))
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getStatusComponent(agent.status), previousToOfflineStatus ? getStatusComponent(previousToOfflineStatus) : null));
};
exports.AgentHealth = AgentHealth;