"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewErrors = void 0;
var _querystring = require("querystring");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireDefault(require("react"));
var _rison = require("@kbn/rison");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _i18n = require("@kbn/i18n");
var _build_query = require("../../agent_details_page/components/agent_logs/build_query");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TruncatedEuiText = (0, _styledComponents.default)(_eui.EuiText)`
  overflow: hidden;
  max-height: 3rem;
  text-overflow: ellipsis;
`;
const ViewErrors = ({
  action
}) => {
  var _action$latestErrors2;
  const coreStart = (0, _hooks.useStartServices)();
  const logStreamQuery = agentId => (0, _build_query.buildQuery)({
    agentId,
    datasets: ['elastic_agent'],
    logLevels: ['error'],
    userQuery: ''
  });
  const getErrorLogsUrl = (agentId, timestamp) => {
    const queryParams = (0, _querystring.stringify)({
      logPosition: (0, _rison.encode)({
        position: {
          time: Date.parse(timestamp)
        },
        streamLive: false
      }),
      logFilter: (0, _rison.encode)({
        expression: logStreamQuery(agentId),
        kind: 'kuery'
      })
    });
    return coreStart.http.basePath.prepend(`/app/logs/stream?${queryParams}`);
  };
  const columns = [{
    field: 'hostname',
    name: _i18n.i18n.translate('xpack.fleet.agentList.viewErrors.hostnameColumnTitle', {
      defaultMessage: 'Host Name'
    }),
    render: hostname => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": "hostText"
    }, hostname)
  }, {
    field: 'error',
    name: _i18n.i18n.translate('xpack.fleet.agentList.viewErrors.errorColumnTitle', {
      defaultMessage: 'Error Message'
    }),
    render: error => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: error
    }, /*#__PURE__*/_react.default.createElement(TruncatedEuiText, {
      size: "s",
      color: "red",
      "data-test-subj": "errorText"
    }, error))
  }, {
    field: 'agentId',
    name: _i18n.i18n.translate('xpack.fleet.agentList.viewErrors.actionColumnTitle', {
      defaultMessage: 'Action'
    }),
    render: agentId => {
      var _action$latestErrors;
      const errorItem = ((_action$latestErrors = action.latestErrors) !== null && _action$latestErrors !== void 0 ? _action$latestErrors : []).find(item => item.agentId === agentId);
      return /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
        coreStart: coreStart
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        href: getErrorLogsUrl(agentId, errorItem.timestamp),
        color: "danger",
        "data-test-subj": "viewLogsBtn"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.reviewErrorLogs",
        defaultMessage: "Review error logs"
      })));
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: action.actionId + '_errors',
    buttonContent: "Show errors"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: (_action$latestErrors2 = action.latestErrors) !== null && _action$latestErrors2 !== void 0 ? _action$latestErrors2 : [],
    columns: columns,
    tableLayout: "auto"
  })));
};
exports.ViewErrors = ViewErrors;