"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableRowActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../../../../../common/services");
var _hooks = require("../../../../hooks");
var _components = require("../../../../components");
var _services2 = require("../../../../services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TableRowActions = ({
  agent,
  agentPolicy,
  onReassignClick,
  onUnenrollClick,
  onUpgradeClick,
  onAddRemoveTagsClick,
  onRequestDiagnosticsClick
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const hasFleetAllPrivileges = (0, _hooks.useAuthz)().fleet.all;
  const isUnenrolling = agent.status === 'unenrolling';
  const kibanaVersion = (0, _hooks.useKibanaVersion)();
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const {
    diagnosticFileUploadEnabled
  } = _services2.ExperimentalFeaturesService.get();
  const menuItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "inspect",
    href: getHref('agent_details', {
      agentId: agent.id
    }),
    key: "viewAgent"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.viewActionText",
    defaultMessage: "View agent"
  }))];
  if ((agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.is_managed) === false) {
    menuItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "tag",
      onClick: event => {
        onAddRemoveTagsClick(event.target.closest('button'));
      },
      disabled: !agent.active,
      key: "addRemoveTags"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.addRemoveTagsActionText",
      defaultMessage: "Add / remove tags"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "pencil",
      onClick: () => {
        onReassignClick();
      },
      disabled: !agent.active,
      key: "reassignPolicy"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.reassignActionText",
      defaultMessage: "Assign to new policy"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "agentUnenrollBtn",
      disabled: !hasFleetAllPrivileges || !agent.active,
      icon: "trash",
      onClick: () => {
        onUnenrollClick();
      }
    }, isUnenrolling ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.forceUnenrollOneButton",
      defaultMessage: "Force unenroll"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.unenrollOneButton",
      defaultMessage: "Unenroll agent"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "agentUpgradeBtn",
      icon: "refresh",
      disabled: !(0, _services2.isAgentUpgradeable)(agent, kibanaVersion),
      onClick: () => {
        onUpgradeClick();
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.upgradeOneButton",
      defaultMessage: "Upgrade agent"
    })));
  }
  if (diagnosticFileUploadEnabled) {
    menuItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "requestAgentDiagnosticsBtn",
      icon: "download",
      "data-test-subj": "requestAgentDiagnosticsBtn",
      disabled: !hasFleetAllPrivileges || !(0, _services.isAgentRequestDiagnosticsSupported)(agent),
      onClick: () => {
        onRequestDiagnosticsClick();
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.diagnosticsOneButton",
      defaultMessage: "Request diagnostics .zip"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_components.ContextMenuActions, {
    isOpen: isMenuOpen,
    onChange: isOpen => setIsMenuOpen(isOpen),
    items: menuItems
  });
};
exports.TableRowActions = TableRowActions;