"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchAndFilterBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _components = require("../../../../components");
var _constants = require("../../../../constants");
var _utils = require("../utils");
var _bulk_actions = require("./bulk_actions");
var _agent_activity_button = require("./agent_activity_button");
var _agent_status_filter = require("./agent_status_filter");
var _dashboards_buttons = require("./dashboards_buttons");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ClearAllTagsFilterItem = (0, _styledComponents.default)(_eui.EuiFilterSelectItem)`
  padding: ${props => props.theme.eui.euiSizeS};
`;
const SearchAndFilterBar = ({
  agentPolicies,
  draftKuery,
  onDraftKueryChange,
  onSubmitSearch,
  selectedAgentPolicies,
  onSelectedAgentPoliciesChange,
  selectedStatus,
  onSelectedStatusChange,
  showUpgradeable,
  onShowUpgradeableChange,
  tags,
  selectedTags,
  onSelectedTagsChange,
  totalAgents,
  totalInactiveAgents,
  selectionMode,
  currentQuery,
  selectedAgents,
  refreshAgents,
  onClickAddAgent,
  onClickAddFleetServer,
  visibleAgents,
  onClickAgentActivity,
  showAgentActivityTour
}) => {
  // Policies state for filtering
  const [isAgentPoliciesFilterOpen, setIsAgentPoliciesFilterOpen] = (0, _react.useState)(false);
  const [isTagsFilterOpen, setIsTagsFilterOpen] = (0, _react.useState)(false);

  // Add a agent policy id to current search
  const addAgentPolicyFilter = policyId => {
    onSelectedAgentPoliciesChange([...selectedAgentPolicies, policyId]);
  };

  // Remove a agent policy id from current search
  const removeAgentPolicyFilter = policyId => {
    onSelectedAgentPoliciesChange(selectedAgentPolicies.filter(agentPolicy => agentPolicy !== policyId));
  };
  const addTagsFilter = tag => {
    onSelectedTagsChange([...selectedTags, tag]);
  };
  const removeTagsFilter = tag => {
    onSelectedTagsChange(selectedTags.filter(t => t !== tag));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, totalAgents > 0 && /*#__PURE__*/_react.default.createElement(_dashboards_buttons.DashboardsButtons, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_agent_activity_button.AgentActivityButton, {
    onClickAgentActivity: onClickAgentActivity,
    showAgentActivityTour: showAgentActivityTour
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.addFleetServerButton.tooltip",
      defaultMessage: "Fleet Server is a component of the Elastic Stack used to centrally manage Elastic Agents"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onClickAddFleetServer,
    "data-test-subj": "addFleetServerButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.addFleetServerButton",
    defaultMessage: "Add Fleet Server"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.addAgentButton.tooltip",
      defaultMessage: "Add Elastic Agents to your hosts to collect data and send it to the Elastic Stack"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onClickAddAgent,
    "data-test-subj": "addAgentButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.addButton",
    defaultMessage: "Add agent"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_components.SearchBar, {
    value: draftKuery,
    onChange: (newSearch, submit) => {
      onDraftKueryChange(newSearch);
      if (submit) {
        onSubmitSearch(newSearch);
      }
    },
    indexPattern: _constants.AGENTS_INDEX,
    dataTestSubj: "agentList.queryInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_agent_status_filter.AgentStatusFilter, {
    selectedStatus: selectedStatus,
    onSelectedStatusChange: onSelectedStatusChange,
    totalInactiveAgents: totalInactiveAgents,
    disabled: agentPolicies.length === 0
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      onClick: () => setIsTagsFilterOpen(!isTagsFilterOpen),
      isSelected: isTagsFilterOpen,
      hasActiveFilters: selectedTags.length > 0,
      numActiveFilters: selectedTags.length,
      numFilters: tags.length,
      disabled: tags.length === 0,
      "data-test-subj": "agentList.tagsFilter"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.tagsFilterText",
      defaultMessage: "Tags"
    })),
    isOpen: isTagsFilterOpen,
    closePopover: () => setIsTagsFilterOpen(false),
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "euiFilterSelect__items"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tags.map((tag, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
    checked: selectedTags.includes(tag) ? 'on' : undefined,
    key: index,
    onClick: () => {
      if (selectedTags.includes(tag)) {
        removeTagsFilter(tag);
      } else {
        addTagsFilter(tag);
      }
    }
  }, tag.length > _utils.MAX_TAG_DISPLAY_LENGTH ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tag
  }, /*#__PURE__*/_react.default.createElement("span", null, (0, _utils.truncateTag)(tag))) : tag)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(ClearAllTagsFilterItem, {
    showIcons: false,
    onClick: () => {
      onSelectedTagsChange([]);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "error",
    color: "danger",
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, "Clear all")))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      onClick: () => setIsAgentPoliciesFilterOpen(!isAgentPoliciesFilterOpen),
      isSelected: isAgentPoliciesFilterOpen,
      hasActiveFilters: selectedAgentPolicies.length > 0,
      numActiveFilters: selectedAgentPolicies.length,
      numFilters: agentPolicies.length,
      disabled: agentPolicies.length === 0,
      "data-test-subj": "agentList.policyFilter"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.policyFilterText",
      defaultMessage: "Agent policy"
    })),
    isOpen: isAgentPoliciesFilterOpen,
    closePopover: () => setIsAgentPoliciesFilterOpen(false),
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "euiFilterSelect__items"
  }, agentPolicies.map((agentPolicy, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
    checked: selectedAgentPolicies.includes(agentPolicy.id) ? 'on' : undefined,
    key: index,
    onClick: () => {
      if (selectedAgentPolicies.includes(agentPolicy.id)) {
        removeAgentPolicyFilter(agentPolicy.id);
      } else {
        addAgentPolicyFilter(agentPolicy.id);
      }
    }
  }, agentPolicy.name)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    hasActiveFilters: showUpgradeable,
    onClick: () => {
      onShowUpgradeableChange(!showUpgradeable);
    },
    "data-test-subj": "agentList.showUpgradeable"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.showUpgradeableFilterLabel",
    defaultMessage: "Upgrade available"
  })))), selectionMode === 'manual' && selectedAgents.length || selectionMode === 'query' && totalAgents > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_bulk_actions.AgentBulkActions, {
    totalAgents: totalAgents,
    totalInactiveAgents: totalInactiveAgents,
    selectionMode: selectionMode,
    currentQuery: currentQuery,
    selectedAgents: selectedAgents,
    visibleAgents: visibleAgents,
    refreshAgents: refreshAgents,
    allTags: tags,
    agentPolicies: agentPolicies
  })) : null))));
};
exports.SearchAndFilterBar = SearchAndFilterBar;