"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentActivityButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentActivityButton = ({
  onClickAgentActivity,
  showAgentActivityTour
}) => {
  const {
    uiSettings
  } = (0, _hooks.useStartServices)();
  const [agentActivityTourState, setAgentActivityTourState] = (0, _react.useState)(showAgentActivityTour);
  const isTourHidden = uiSettings.get('hideAgentActivityTour', false);
  const setTourAsHidden = () => uiSettings.set('hideAgentActivityTour', true);
  (0, _react.useEffect)(() => {
    setAgentActivityTourState(showAgentActivityTour);
  }, [showAgentActivityTour, setAgentActivityTourState]);
  const onFinish = () => {
    setAgentActivityTourState({
      isOpen: false
    });
    setTourAsHidden();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityButton.tourContent",
      defaultMessage: "Review in progress, completed, and scheduled agent action activity history here anytime."
    })),
    isStepOpen: !isTourHidden && agentActivityTourState.isOpen,
    onFinish: onFinish,
    minWidth: 360,
    maxWidth: 360,
    step: 1,
    stepsTotal: 1,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityButton.tourTitle",
      defaultMessage: "Agent activity history"
    }),
    anchorPosition: "upCenter",
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: onFinish
    }, "OK"),
    anchor: "#agentActivityButton"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      onClickAgentActivity();
      setAgentActivityTourState({
        isOpen: false
      });
    },
    "data-test-subj": "agentActivityButton",
    iconType: "clock",
    id: "agentActivityButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.agentActivityButton",
    defaultMessage: "Agent activity"
  })));
};
exports.AgentActivityButton = AgentActivityButton;