"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogQueryBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-search-plugin/public");
var _hooks = require("../../../../../hooks");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXCLUDED_FIELDS = [_constants.AGENT_ID_FIELD.name, _constants.DATASET_FIELD.name, _constants.LOG_LEVEL_FIELD.name];
const LogQueryBar = /*#__PURE__*/(0, _react.memo)(({
  query,
  isQueryValid,
  onUpdateQuery
}) => {
  const {
    data,
    notifications,
    http,
    docLinks,
    uiSettings,
    unifiedSearch,
    storage,
    dataViews
  } = (0, _hooks.useStartServices)();
  const [indexPatternFields, setIndexPatternFields] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const fetchFields = async () => {
      try {
        const fields = ((await data.dataViews.getFieldsForWildcard({
          pattern: _constants.AGENT_LOG_INDEX_PATTERN
        })) || []).filter(field => {
          return !EXCLUDED_FIELDS.includes(field.name);
        });
        setIndexPatternFields(fields);
      } catch (err) {
        setIndexPatternFields(undefined);
      }
    };
    fetchFields();
  }, [data.dataViews]);
  return /*#__PURE__*/_react.default.createElement(_public.QueryStringInput, {
    iconType: "search",
    autoSubmit: true,
    disableLanguageSwitcher: true,
    indexPatterns: indexPatternFields ? [{
      title: _constants.AGENT_LOG_INDEX_PATTERN,
      fields: indexPatternFields
    }] : [],
    query: {
      query,
      language: 'kuery'
    },
    isInvalid: !isQueryValid,
    disableAutoFocus: true,
    placeholder: _i18n.i18n.translate('xpack.fleet.agentLogs.searchPlaceholderText', {
      defaultMessage: 'Search logs…'
    }),
    onChange: newQuery => {
      onUpdateQuery(newQuery.query);
    },
    onSubmit: newQuery => {
      onUpdateQuery(newQuery.query, true);
    },
    appName: _i18n.i18n.translate('xpack.fleet.appTitle', {
      defaultMessage: 'Fleet'
    }),
    deps: {
      unifiedSearch,
      notifications,
      http,
      docLinks,
      uiSettings,
      data,
      dataViews,
      storage
    }
  });
});
exports.LogQueryBar = LogQueryBar;