"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STATE_STORAGE_KEY = exports.STATE_DATASET_FIELD = exports.LOG_LEVEL_FIELD = exports.DEFAULT_LOG_LEVEL = exports.DEFAULT_LOGS_STATE = exports.DEFAULT_DATE_RANGE = exports.DATASET_FIELD = exports.AGENT_LOG_LEVELS = exports.AGENT_LOG_INDEX_PATTERN = exports.AGENT_ID_FIELD = exports.AGENT_DATASET_PATTERN = exports.AGENT_DATASET_OSQUERYBEAT = exports.AGENT_DATASET_METRICBEAT = exports.AGENT_DATASET_HEARTBEAT = exports.AGENT_DATASET_FILEBEAT = exports.AGENT_DATASET_ENDPOINT_SECURITY = exports.AGENT_DATASET_APM_SERVER = exports.AGENT_DATASET = void 0;
var _constants = require("../../../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENT_LOG_INDEX_PATTERN = 'logs-elastic_agent-*,logs-elastic_agent.*-*';
exports.AGENT_LOG_INDEX_PATTERN = AGENT_LOG_INDEX_PATTERN;
const AGENT_DATASET = 'elastic_agent';
exports.AGENT_DATASET = AGENT_DATASET;
const AGENT_DATASET_FILEBEAT = 'elastic_agent.filebeat';
exports.AGENT_DATASET_FILEBEAT = AGENT_DATASET_FILEBEAT;
const AGENT_DATASET_METRICBEAT = 'elastic_agent.metricbeat';
exports.AGENT_DATASET_METRICBEAT = AGENT_DATASET_METRICBEAT;
const AGENT_DATASET_OSQUERYBEAT = 'elastic_agent.osquerybeat';
exports.AGENT_DATASET_OSQUERYBEAT = AGENT_DATASET_OSQUERYBEAT;
const AGENT_DATASET_HEARTBEAT = 'elastic_agent.heartbeat';
exports.AGENT_DATASET_HEARTBEAT = AGENT_DATASET_HEARTBEAT;
const AGENT_DATASET_APM_SERVER = 'elastic_agent.apm_server';
exports.AGENT_DATASET_APM_SERVER = AGENT_DATASET_APM_SERVER;
const AGENT_DATASET_ENDPOINT_SECURITY = 'elastic_agent.endpoint_security';
exports.AGENT_DATASET_ENDPOINT_SECURITY = AGENT_DATASET_ENDPOINT_SECURITY;
const AGENT_DATASET_PATTERN = 'elastic_agent.*';
exports.AGENT_DATASET_PATTERN = AGENT_DATASET_PATTERN;
const AGENT_ID_FIELD = {
  name: 'elastic_agent.id',
  type: 'string'
};
exports.AGENT_ID_FIELD = AGENT_ID_FIELD;
const DATASET_FIELD = {
  name: _constants.DATASET_VAR_NAME,
  type: 'string',
  aggregatable: true,
  searchable: true
};
exports.DATASET_FIELD = DATASET_FIELD;
const LOG_LEVEL_FIELD = {
  name: 'log.level',
  type: 'string',
  aggregatable: true,
  searchable: true
};
exports.LOG_LEVEL_FIELD = LOG_LEVEL_FIELD;
const DEFAULT_DATE_RANGE = {
  start: 'now-1d',
  end: 'now'
};
exports.DEFAULT_DATE_RANGE = DEFAULT_DATE_RANGE;
const DEFAULT_LOGS_STATE = {
  start: DEFAULT_DATE_RANGE.start,
  end: DEFAULT_DATE_RANGE.end,
  logLevels: [],
  datasets: [AGENT_DATASET],
  query: ''
};
exports.DEFAULT_LOGS_STATE = DEFAULT_LOGS_STATE;
const STATE_STORAGE_KEY = '_q';
exports.STATE_STORAGE_KEY = STATE_STORAGE_KEY;
const STATE_DATASET_FIELD = 'datasets';
exports.STATE_DATASET_FIELD = STATE_DATASET_FIELD;
const AGENT_LOG_LEVELS = {
  ERROR: 'error',
  WARNING: 'warning',
  INFO: 'info',
  DEBUG: 'debug'
};
exports.AGENT_LOG_LEVELS = AGENT_LOG_LEVELS;
const DEFAULT_LOG_LEVEL = AGENT_LOG_LEVELS.INFO;
exports.DEFAULT_LOG_LEVEL = DEFAULT_LOG_LEVEL;