"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentDetailsActionMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../../../../../common/services");
var _hooks = require("../../../../hooks");
var _components = require("../../../../components");
var _components2 = require("../../components");
var _hooks2 = require("../hooks");
var _services2 = require("../../../../services");
var _agent_request_diagnostics_modal = require("../../components/agent_request_diagnostics_modal");
var _agent_details_json_flyout = require("./agent_details_json_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentDetailsActionMenu = /*#__PURE__*/(0, _react.memo)(({
  agent,
  assignFlyoutOpenByDefault = false,
  onCancelReassign,
  agentPolicy
}) => {
  const hasFleetAllPrivileges = (0, _hooks.useAuthz)().fleet.all;
  const kibanaVersion = (0, _hooks.useKibanaVersion)();
  const refreshAgent = (0, _hooks2.useAgentRefresh)();
  const [isReassignFlyoutOpen, setIsReassignFlyoutOpen] = (0, _react.useState)(assignFlyoutOpenByDefault);
  const [isUnenrollModalOpen, setIsUnenrollModalOpen] = (0, _react.useState)(false);
  const [isUpgradeModalOpen, setIsUpgradeModalOpen] = (0, _react.useState)(false);
  const [isRequestDiagnosticsModalOpen, setIsRequestDiagnosticsModalOpen] = (0, _react.useState)(false);
  const [isAgentDetailsJsonFlyoutOpen, setIsAgentDetailsJsonFlyoutOpen] = (0, _react.useState)(false);
  const isUnenrolling = agent.status === 'unenrolling';
  const [isContextMenuOpen, setIsContextMenuOpen] = (0, _react.useState)(false);
  const onContextMenuChange = (0, _react.useCallback)(open => {
    setIsContextMenuOpen(open);
  }, [setIsContextMenuOpen]);
  const hasFleetServer = agentPolicy && (0, _services2.policyHasFleetServer)(agentPolicy);
  const {
    diagnosticFileUploadEnabled
  } = _services2.ExperimentalFeaturesService.get();
  const onClose = (0, _react.useMemo)(() => {
    if (onCancelReassign) {
      return onCancelReassign;
    } else {
      return () => setIsReassignFlyoutOpen(false);
    }
  }, [onCancelReassign, setIsReassignFlyoutOpen]);
  const menuItems = [];
  if (!(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_managed)) {
    menuItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "pencil",
      onClick: () => {
        setIsReassignFlyoutOpen(true);
      },
      disabled: !agent.active && !agentPolicy,
      key: "reassignPolicy"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.reassignActionText",
      defaultMessage: "Assign to new policy"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "trash",
      disabled: !hasFleetAllPrivileges || !agent.active,
      onClick: () => {
        setIsUnenrollModalOpen(true);
      },
      key: "unenrollAgent"
    }, isUnenrolling ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.forceUnenrollOneButton",
      defaultMessage: "Force unenroll"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.unenrollOneButton",
      defaultMessage: "Unenroll agent"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "refresh",
      disabled: !(0, _services2.isAgentUpgradeable)(agent, kibanaVersion),
      onClick: () => {
        setIsUpgradeModalOpen(true);
      },
      key: "upgradeAgent"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.upgradeOneButton",
      defaultMessage: "Upgrade agent"
    })));
  }
  menuItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "inspect",
    onClick: () => {
      setIsContextMenuOpen(false);
      setIsAgentDetailsJsonFlyoutOpen(!isAgentDetailsJsonFlyoutOpen);
    },
    key: "agentDetailsJson",
    "data-test-subj": "viewAgentDetailsJsonBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.viewAgentDetailsJsonText",
    defaultMessage: "View agent JSON"
  })));
  if (diagnosticFileUploadEnabled) {
    menuItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "download",
      disabled: !hasFleetAllPrivileges || !(0, _services.isAgentRequestDiagnosticsSupported)(agent),
      onClick: () => {
        setIsRequestDiagnosticsModalOpen(true);
      },
      "data-test-subj": "requestAgentDiagnosticsBtn",
      key: "requestDiagnostics"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.diagnosticsOneButton",
      defaultMessage: "Request diagnostics .zip"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isReassignFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components2.AgentReassignAgentPolicyModal, {
    agents: [agent],
    onClose: onClose
  })), isUnenrollModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components2.AgentUnenrollAgentModal, {
    agents: [agent],
    agentCount: 1,
    onClose: () => {
      setIsUnenrollModalOpen(false);
      refreshAgent();
    },
    useForceUnenroll: isUnenrolling,
    hasFleetServer: hasFleetServer
  })), isUpgradeModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components2.AgentUpgradeAgentModal, {
    agents: [agent],
    agentCount: 1,
    onClose: () => {
      setIsUpgradeModalOpen(false);
      refreshAgent();
    }
  })), isRequestDiagnosticsModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_agent_request_diagnostics_modal.AgentRequestDiagnosticsModal, {
    agents: [agent],
    agentCount: 1,
    onClose: () => {
      setIsRequestDiagnosticsModalOpen(false);
    }
  })), isAgentDetailsJsonFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_agent_details_json_flyout.AgentDetailsJsonFlyout, {
    agent: agent,
    onClose: () => setIsAgentDetailsJsonFlyoutOpen(false)
  })), /*#__PURE__*/_react.default.createElement(_components.ContextMenuActions, {
    isOpen: isContextMenuOpen,
    onChange: onContextMenuChange,
    button: {
      props: {
        iconType: 'arrowDown',
        iconSide: 'right',
        color: 'primary'
      },
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentDetails.actionsButton",
        defaultMessage: "Actions"
      })
    },
    items: menuItems
  }));
});
exports.AgentDetailsActionMenu = AgentDetailsActionMenu;