"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeStatusCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  .euiFlyoutBody__overflowContent {
    padding: 0;
  }
`;
const UpgradeStatusCallout = ({
  dryRunData
}) => {
  var _dryRunData$0$agent_d, _currentPackagePolicy, _proposedUpgradePacka, _currentPackagePolicy2, _proposedUpgradePacka2;
  const [isPreviousVersionFlyoutOpen, setIsPreviousVersionFlyoutOpen] = (0, _react.useState)(false);
  if (!dryRunData) {
    return null;
  }
  const isReadyForUpgrade = !dryRunData[0].hasErrors;
  const [currentPackagePolicy, proposedUpgradePackagePolicy] = dryRunData[0].diff || [];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isPreviousVersionFlyoutOpen && currentPackagePolicy && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setIsPreviousVersionFlyoutOpen(false),
    size: "l",
    maxWidth: 640
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "FleetPackagePolicyPreviousVersionFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradePackagePolicy.previousVersionFlyout.title",
    defaultMessage: "'{name}' integration policy",
    values: {
      name: currentPackagePolicy === null || currentPackagePolicy === void 0 ? void 0 : currentPackagePolicy.name
    }
  })))), /*#__PURE__*/_react.default.createElement(FlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    fontSize: "m",
    whiteSpace: "pre"
  }, JSON.stringify(((_dryRunData$0$agent_d = dryRunData[0].agent_diff) === null || _dryRunData$0$agent_d === void 0 ? void 0 : _dryRunData$0$agent_d[0]) || [], null, 2))))), isReadyForUpgrade && currentPackagePolicy ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.upgradePackagePolicy.statusCallOut.successTitle', {
      defaultMessage: 'Ready to upgrade'
    }),
    color: "success",
    iconType: "checkInCircleFilled"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradePackagePolicy.statusCallout.successContent",
    defaultMessage: "This integration is ready to be upgraded from version {currentVersion} to {upgradeVersion}. Review the changes below and save to upgrade.",
    values: {
      currentVersion: currentPackagePolicy === null || currentPackagePolicy === void 0 ? void 0 : (_currentPackagePolicy = currentPackagePolicy.package) === null || _currentPackagePolicy === void 0 ? void 0 : _currentPackagePolicy.version,
      upgradeVersion: proposedUpgradePackagePolicy === null || proposedUpgradePackagePolicy === void 0 ? void 0 : (_proposedUpgradePacka = proposedUpgradePackagePolicy.package) === null || _proposedUpgradePacka === void 0 ? void 0 : _proposedUpgradePacka.version
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.upgradePackagePolicy.statusCallOut.errorTitle', {
      defaultMessage: 'Review field conflicts'
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradePackagePolicy.statusCallout.errorContent",
    defaultMessage: "This integration has conflicting fields from version {currentVersion} to {upgradeVersion} Review the configuration and save to perform the upgrade. You may reference your {previousConfigurationLink} for comparison.",
    values: {
      currentVersion: currentPackagePolicy === null || currentPackagePolicy === void 0 ? void 0 : (_currentPackagePolicy2 = currentPackagePolicy.package) === null || _currentPackagePolicy2 === void 0 ? void 0 : _currentPackagePolicy2.version,
      upgradeVersion: proposedUpgradePackagePolicy === null || proposedUpgradePackagePolicy === void 0 ? void 0 : (_proposedUpgradePacka2 = proposedUpgradePackagePolicy.package) === null || _proposedUpgradePacka2 === void 0 ? void 0 : _proposedUpgradePacka2.version,
      previousConfigurationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => setIsPreviousVersionFlyoutOpen(true)
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.upgradePackagePolicy.statusCallout.previousConfigurationLink",
        defaultMessage: "previous configuration"
      }))
    }
  })));
};
exports.UpgradeStatusCallout = UpgradeStatusCallout;