"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyDetailsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../constants");
var _hooks = require("../../../hooks");
var _components = require("../../../components");
var _layouts = require("../../../layouts");
var _hooks2 = require("./hooks");
var _components2 = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyDetailsPage = () => {
  var _agentStatusRequest$d;
  const {
    params: {
      policyId,
      tabId = ''
    }
  } = (0, _reactRouterDom.useRouteMatch)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const agentPolicyRequest = (0, _hooks.useGetOneAgentPolicy)(policyId);
  const agentPolicy = agentPolicyRequest.data ? agentPolicyRequest.data.item : null;
  const {
    isLoading,
    error,
    sendRequest: refreshAgentPolicy
  } = agentPolicyRequest;
  const queryParams = new URLSearchParams((0, _reactRouterDom.useLocation)().search);
  const openEnrollmentFlyoutOpenByDefault = queryParams.get('openEnrollmentFlyout') === 'true';
  const openAddAgentHelpPopoverOpenByDefault = queryParams.get('showAddAgentHelp') === 'true';
  const [redirectToAgentPolicyList] = (0, _react.useState)(false);
  const [isEnrollmentFlyoutOpen, setIsEnrollmentFlyoutOpen] = (0, _react.useState)(openEnrollmentFlyoutOpenByDefault);
  const [isAddAgentHelpPopoverOpen, setIsAddAgentHelpPopoverOpen] = (0, _react.useState)(openAddAgentHelpPopoverOpenByDefault);
  const agentStatusRequest = (0, _hooks2.useGetAgentStatus)(policyId);
  const {
    refreshAgentStatus
  } = agentStatusRequest;
  const {
    application: {
      navigateToApp
    }
  } = (0, _hooks.useStartServices)();
  const routeState = (0, _hooks.useIntraAppState)();
  const agentStatus = (_agentStatusRequest$d = agentStatusRequest.data) === null || _agentStatusRequest$d === void 0 ? void 0 : _agentStatusRequest$d.results;
  const {
    isReady: isFleetReady
  } = (0, _hooks.useFleetStatus)();
  const onCancelEnrollment = (0, _react.useMemo)(() => {
    if (routeState && routeState.onDoneNavigateTo && isFleetReady) {
      const [appId, options] = routeState.onDoneNavigateTo;
      return () => navigateToApp(appId, options);
    }
    return undefined;
  }, [isFleetReady, navigateToApp, routeState]);
  const addAgent = (0, _react.useCallback)(() => {
    setIsAddAgentHelpPopoverOpen(false);
    setIsEnrollmentFlyoutOpen(true);
  }, []);
  const headerTabs = (0, _react.useMemo)(() => {
    return [{
      id: 'integrations',
      name: _i18n.i18n.translate('xpack.fleet.policyDetails.subTabs.packagePoliciesTabText', {
        defaultMessage: 'Integrations'
      }),
      href: getHref('policy_details', {
        policyId,
        tabId: 'integrations'
      }),
      isSelected: tabId === '' || tabId === 'integrations'
    }, {
      id: 'settings',
      name: _i18n.i18n.translate('xpack.fleet.policyDetails.subTabs.settingsTabText', {
        defaultMessage: 'Settings'
      }),
      href: getHref('policy_details', {
        policyId,
        tabId: 'settings'
      }),
      isSelected: tabId === 'settings'
    }];
  }, [getHref, policyId, tabId]);
  const content = (0, _react.useMemo)(() => {
    if (redirectToAgentPolicyList) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: "/"
      });
    }
    if (isLoading) {
      return /*#__PURE__*/_react.default.createElement(_components.Loading, null);
    }
    if (error) {
      return /*#__PURE__*/_react.default.createElement(_components.Error, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.policyDetails.unexceptedErrorTitle",
          defaultMessage: "An error happened while loading the agent policy"
        }),
        error: error
      });
    }
    if (!agentPolicy) {
      return /*#__PURE__*/_react.default.createElement(_components.Error, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.policyDetails.unexceptedErrorTitle",
          defaultMessage: "An error happened while loading the agent policy"
        }),
        error: _i18n.i18n.translate('xpack.fleet.policyDetails.policyNotFoundErrorTitle', {
          defaultMessage: "Policy '{id}' not found",
          values: {
            id: policyId
          }
        })
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEnrollmentFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components.AgentEnrollmentFlyout, {
      agentPolicy: agentPolicy,
      onClose: onCancelEnrollment || (() => setIsEnrollmentFlyoutOpen(false))
    })), /*#__PURE__*/_react.default.createElement(AgentPolicyDetailsContent, {
      agentPolicy: agentPolicy
    }));
  }, [redirectToAgentPolicyList, isLoading, error, agentPolicy, isEnrollmentFlyoutOpen, onCancelEnrollment, policyId]);
  const headerLeftContent = /*#__PURE__*/_react.default.createElement(_components2.HeaderLeftContent, {
    agentPolicy: agentPolicy,
    policyId: policyId,
    isLoading: isLoading
  });
  const headerRightContent = /*#__PURE__*/_react.default.createElement(_components2.HeaderRightContent, {
    agentPolicy: agentPolicy,
    agentStatus: agentStatus,
    policyId: policyId,
    onCancelEnrollment: onCancelEnrollment,
    isLoading: isLoading,
    isAddAgentHelpPopoverOpen: isAddAgentHelpPopoverOpen,
    setIsAddAgentHelpPopoverOpen: setIsAddAgentHelpPopoverOpen,
    addAgent: addAgent
  });
  return /*#__PURE__*/_react.default.createElement(_hooks.AgentPolicyRefreshContext.Provider, {
    value: {
      refresh: refreshAgentPolicy
    }
  }, /*#__PURE__*/_react.default.createElement(_hooks2.AgentStatusRefreshContext.Provider, {
    value: {
      refresh: refreshAgentStatus
    }
  }, /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: headerLeftContent,
    rightColumn: headerRightContent,
    tabs: headerTabs
  }, content)));
};
exports.AgentPolicyDetailsPage = AgentPolicyDetailsPage;
const AgentPolicyDetailsContent = ({
  agentPolicy
}) => {
  (0, _hooks.useBreadcrumbs)('policy_details', {
    policyName: agentPolicy.name
  });
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.policy_details_settings,
    render: () => {
      return /*#__PURE__*/_react.default.createElement(_components2.SettingsView, {
        agentPolicy: agentPolicy
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.policy_details,
    render: () => {
      return /*#__PURE__*/_react.default.createElement(_components2.PackagePoliciesView, {
        agentPolicy: agentPolicy
      });
    }
  }));
};