"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreatePackagePolicySinglePageLayout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _layouts = require("../../../../../layouts");
var _components = require("../../../../../components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyName = (0, _styledComponents.default)(_eui.EuiDescriptionListDescription)`
  margin-left: auto;
  max-width: 250px;
  text-overflow: ellipsis;
  white-space: nowrap;
  overflow: hidden;
`;
const CreatePackagePolicySinglePageLayout = /*#__PURE__*/(0, _react.memo)(({
  from,
  cancelUrl,
  onCancel,
  agentPolicy,
  packageInfo,
  integrationInfo,
  children,
  'data-test-subj': dataTestSubj,
  tabs = []
}) => {
  const isAdd = (0, _react.useMemo)(() => ['package', 'policy'].includes(from), [from]);
  const isEdit = (0, _react.useMemo)(() => ['edit', 'package-edit'].includes(from), [from]);
  const isUpgrade = (0, _react.useMemo)(() => ['upgrade-from-fleet-policy-list', 'upgrade-from-integrations-policy-list', 'upgrade-from-extension'].includes(from), [from]);
  const pageTitle = (0, _react.useMemo)(() => {
    if ((isAdd || isEdit || isUpgrade) && packageInfo) {
      let pageTitleText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.pageTitleWithPackageName",
        defaultMessage: "Add {packageName} integration",
        values: {
          packageName: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title) || packageInfo.title
        }
      });
      if (isEdit) {
        pageTitleText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.editPackagePolicy.editPageTitleWithPackageName",
          defaultMessage: "Edit {packageName} integration",
          values: {
            packageName: packageInfo.title
          }
        });
      } else if (isUpgrade) {
        pageTitleText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.editPackagePolicy.upgradePageTitleWithPackageName",
          defaultMessage: "Upgrade {packageName} integration",
          values: {
            packageName: packageInfo.title
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "m"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_components.PackageIcon, {
        packageName: (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name) || '',
        integrationName: integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name,
        version: (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.version) || '',
        icons: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.icons) || (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.icons),
        size: "xl"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", {
        "data-test-subj": `${dataTestSubj}_pageTitle`
      }, pageTitleText))));
    }
    if (isEdit) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", {
        "data-test-subj": `${dataTestSubj}_pageTitle`
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.editPackagePolicy.pageTitle",
        defaultMessage: "Edit integration"
      })));
    }
    if (isUpgrade) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", {
        "data-test-subj": `${dataTestSubj}_pageTitle`
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.upgradePackagePolicy.pageTitle",
        defaultMessage: "Upgrade integration"
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.pageTitle",
      defaultMessage: "Add integration"
    })));
  }, [dataTestSubj, integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.icons, integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name, integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title, packageInfo, isAdd, isEdit, isUpgrade]);
  const pageDescription = (0, _react.useMemo)(() => {
    if (isEdit) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.editPackagePolicy.pageDescription",
        defaultMessage: "Modify integration settings and deploy changes to the selected agent policy."
      });
    } else if (isAdd) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.pageDescriptionfromPolicy",
        defaultMessage: "Configure an integration for the selected agent policy."
      });
    } else if (isUpgrade) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.upgradePackagePolicy.pageDescriptionFromUpgrade",
        defaultMessage: "Upgrade this integration and deploy changes to the selected agent policy"
      });
    } else {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.pageDescriptionfromPackage",
        defaultMessage: "Follow these instructions to add this integration to an agent policy."
      });
    }
  }, [isAdd, isEdit, isUpgrade]);
  const leftColumn = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: "arrowLeft",
    flush: "left",
    href: cancelUrl,
    onClick: onCancel,
    "data-test-subj": `${dataTestSubj}_cancelBackLink`
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.cancelLinkText",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, pageTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, pageDescription)));
  const rightColumn = agentPolicy && (isAdd || isEdit) ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    className: "eui-textRight",
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.agentPolicyNameLabel",
    defaultMessage: "Agent policy"
  })), /*#__PURE__*/_react.default.createElement(AgentPolicyName, {
    className: "eui-textBreakWord",
    title: (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.name) || '-'
  }, (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.name) || '-')) : undefined;
  const maxWidth = 770;
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    restrictHeaderWidth: maxWidth,
    restrictWidth: maxWidth,
    leftColumn: leftColumn,
    rightColumn: rightColumn,
    rightColumnGrow: false,
    "data-test-subj": dataTestSubj,
    tabs: tabs.map(({
      title,
      ...rest
    }) => ({
      name: title,
      ...rest
    }))
  }, children);
});
exports.CreatePackagePolicySinglePageLayout = CreatePackagePolicySinglePageLayout;