"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyInputVarField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactMarkdown = _interopRequireDefault(require("react-markdown"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../../../../../../common/constants");
var _multi_text_input = require("./multi_text_input");
var _dataset_combo = require("./dataset_combo");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FixedHeightDiv = _styledComponents.default.div`
  height: 300px;
`;
const PackagePolicyInputVarField = /*#__PURE__*/(0, _react.memo)(({
  varDef,
  value,
  onChange,
  errors: varErrors,
  forceShowErrors,
  frozen,
  packageType,
  packageName,
  datastreams = [],
  isEditPage = false
}) => {
  const [isDirty, setIsDirty] = (0, _react.useState)(false);
  const {
    multi,
    required,
    type,
    title,
    name,
    description,
    options
  } = varDef;
  const isInvalid = (isDirty || forceShowErrors) && !!(varErrors !== null && varErrors !== void 0 && varErrors.length);
  const errors = isInvalid ? varErrors : null;
  const fieldLabel = title || name;
  const fieldTestSelector = fieldLabel.replace(/\s/g, '-').toLowerCase();
  const field = (0, _react.useMemo)(() => {
    if (multi) {
      return /*#__PURE__*/_react.default.createElement(_multi_text_input.MultiTextInput, {
        value: value !== null && value !== void 0 ? value : [],
        onChange: onChange,
        onBlur: () => setIsDirty(true),
        isDisabled: frozen,
        "data-test-subj": `multiTextInput-${fieldTestSelector}`
      });
    }
    if (name === _constants.DATASET_VAR_NAME && packageType === 'input') {
      return /*#__PURE__*/_react.default.createElement(_dataset_combo.DatasetComboBox, {
        pkgName: packageName,
        datastreams: datastreams,
        value: value,
        onChange: onChange,
        isDisabled: isEditPage
      });
    }
    switch (type) {
      case 'textarea':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
          isInvalid: isInvalid,
          value: value === undefined ? '' : value,
          onChange: e => onChange(e.target.value),
          onBlur: () => setIsDirty(true),
          disabled: frozen,
          resize: "vertical",
          "data-test-subj": `textAreaInput-${fieldTestSelector}`
        });
      case 'yaml':
        return frozen ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          language: "yaml",
          isCopyable: false,
          paddingSize: "s"
        }, /*#__PURE__*/_react.default.createElement("pre", null, value)) : /*#__PURE__*/_react.default.createElement(FixedHeightDiv, null, /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
          languageId: "yaml",
          width: "100%",
          height: "300px",
          value: value,
          onChange: onChange,
          options: {
            minimap: {
              enabled: false
            },
            ariaLabel: _i18n.i18n.translate('xpack.fleet.packagePolicyField.yamlCodeEditor', {
              defaultMessage: 'YAML Code Editor'
            }),
            scrollBeyondLastLine: false,
            wordWrap: 'off',
            wrappingIndent: 'indent',
            tabSize: 2,
            // To avoid left margin
            lineNumbers: 'off',
            lineNumbersMinChars: 0,
            glyphMargin: false,
            folding: false,
            lineDecorationsWidth: 0,
            overviewRulerBorder: false
          }
        }));
      case 'bool':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
          label: fieldLabel,
          checked: value,
          showLabel: false,
          onChange: e => onChange(e.target.checked),
          onBlur: () => setIsDirty(true),
          disabled: frozen,
          "data-test-subj": `switch-${fieldTestSelector}`
        });
      case 'password':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
          type: "dual",
          isInvalid: isInvalid,
          value: value === undefined ? '' : value,
          onChange: e => onChange(e.target.value),
          onBlur: () => setIsDirty(true),
          disabled: frozen,
          "data-test-subj": `passwordInput-${fieldTestSelector}`
        });
      case 'select':
        const selectOptions = options === null || options === void 0 ? void 0 : options.map(option => ({
          value: option.value,
          label: option.text
        }));
        const selectedOptions = value === undefined ? [] : selectOptions === null || selectOptions === void 0 ? void 0 : selectOptions.filter(option => option.value === value);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
          placeholder: _i18n.i18n.translate('xpack.fleet.packagePolicyField.selectPlaceholder', {
            defaultMessage: 'Select an option'
          }),
          singleSelection: {
            asPlainText: true
          },
          options: selectOptions,
          selectedOptions: selectedOptions,
          isClearable: true,
          onChange: newSelectedOptions => {
            const newValue = newSelectedOptions.length === 0 ? undefined : newSelectedOptions[0].value;
            return onChange(newValue);
          },
          onBlur: () => setIsDirty(true),
          "data-test-subj": `select-${fieldTestSelector}`
        });
      default:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          isInvalid: isInvalid,
          value: value === undefined ? '' : value,
          onChange: e => onChange(e.target.value),
          onBlur: () => setIsDirty(true),
          disabled: frozen,
          "data-test-subj": `textInput-${fieldTestSelector}`
        });
    }
  }, [multi, name, packageType, type, value, onChange, frozen, packageName, datastreams, isEditPage, isInvalid, fieldLabel, options, fieldTestSelector]);

  // Boolean cannot be optional by default set to false
  const isOptional = (0, _react.useMemo)(() => type !== 'bool' && !required, [required, type]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: isInvalid,
    error: errors,
    label: fieldLabel,
    labelAppend: isOptional ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.inputVarFieldOptionalLabel",
      defaultMessage: "Optional"
    })) : null,
    helpText: description && /*#__PURE__*/_react.default.createElement(_reactMarkdown.default, {
      children: description
    })
  }, field);
});
exports.PackagePolicyInputVarField = PackagePolicyInputVarField;