"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyInputStreamConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactMarkdown = _interopRequireDefault(require("react-markdown"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../../../../../../../common/constants");
var _hooks = require("../../../../../../../../hooks");
var _services = require("../../../../../../../../../common/services");
var _components = require("../../../../../../components");
var _services2 = require("../../../services");
var _datastream_pipelines = require("../../datastream_pipelines");
var _datastream_mappings = require("../../datastream_mappings");
var _datastream_hooks = require("../../datastream_hooks");
var _experimental_datastream_settings = require("./experimental_datastream_settings");
var _package_policy_input_var_field = require("./package_policy_input_var_field");
var _hooks2 = require("./hooks");
var _sort_datastreams = require("./sort_datastreams");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ScrollAnchor = _styledComponents.default.div`
  display: none;
  scroll-margin-top: ${props => parseFloat(props.theme.eui.euiHeaderHeightCompensation) * 2}px;
`;
const PackagePolicyInputStreamConfig = /*#__PURE__*/(0, _react.memo)(({
  packagePolicy,
  packageInputStream,
  packageInfo,
  packagePolicyInputStream,
  updatePackagePolicy,
  updatePackagePolicyInputStream,
  inputStreamValidationResults,
  forceShowErrors,
  isEditPage
}) => {
  var _config$enableExperim, _config$enableExperim2, _packagePolicyInputSt, _customDatasetVar$val, _uniq, _packagePolicy$packag;
  const config = (0, _hooks.useConfig)();
  const isExperimentalDataStreamSettingsEnabled = (_config$enableExperim = (_config$enableExperim2 = config.enableExperimental) === null || _config$enableExperim2 === void 0 ? void 0 : _config$enableExperim2.includes('experimentalDataStreamSettings')) !== null && _config$enableExperim !== void 0 ? _config$enableExperim : false;
  const {
    params: {
      packagePolicyId
    }
  } = (0, _reactRouterDom.useRouteMatch)();
  const defaultDataStreamId = (0, _hooks2.useDataStreamId)();
  const containerRef = (0, _react.useRef)(null);
  const isDefaultDatastream = !!defaultDataStreamId && !!packagePolicyInputStream.id && packagePolicyInputStream.id === defaultDataStreamId;
  const isPackagePolicyEdit = !!packagePolicyId;
  const customDatasetVar = (_packagePolicyInputSt = packagePolicyInputStream.vars) === null || _packagePolicyInputSt === void 0 ? void 0 : _packagePolicyInputSt[_constants.DATASET_VAR_NAME];
  const customDatasetVarValue = (customDatasetVar === null || customDatasetVar === void 0 ? void 0 : (_customDatasetVar$val = customDatasetVar.value) === null || _customDatasetVar$val === void 0 ? void 0 : _customDatasetVar$val.dataset) || (customDatasetVar === null || customDatasetVar === void 0 ? void 0 : customDatasetVar.value);
  const {
    exists: indexTemplateExists,
    isLoading: isLoadingIndexTemplate
  } = (0, _datastream_hooks.useIndexTemplateExists)((0, _services.getRegistryDataStreamAssetBaseName)({
    dataset: customDatasetVarValue || packageInputStream.data_stream.dataset,
    type: packageInputStream.data_stream.type
  }), isPackagePolicyEdit);

  // only show pipelines and mappings if the matching index template exists
  // in the legacy case (e.g logs package pre 2.0.0) the index template will not exist
  // because we allowed dataset to be customized but didnt create a matching index template
  // for the new dataset.
  const showPipelinesAndMappings = !isLoadingIndexTemplate && indexTemplateExists;
  (0, _react.useEffect)(() => {
    if (isDefaultDatastream && containerRef.current) {
      containerRef.current.scrollIntoView();
    }
  }, [isDefaultDatastream, containerRef]);

  // Errors state
  const hasErrors = forceShowErrors && (0, _services2.validationHasErrors)(inputStreamValidationResults);
  const [requiredVars, advancedVars] = (0, _react.useMemo)(() => {
    const _requiredVars = [];
    const _advancedVars = [];
    if (packageInputStream.vars && packageInputStream.vars.length) {
      packageInputStream.vars.forEach(varDef => {
        if ((0, _services2.isAdvancedVar)(varDef)) {
          _advancedVars.push(varDef);
        } else {
          _requiredVars.push(varDef);
        }
      });
    }
    return [_requiredVars, _advancedVars];
  }, [packageInputStream.vars]);
  const advancedVarsWithErrorsCount = (0, _react.useMemo)(() => advancedVars.filter(({
    name: varName
  }) => {
    var _inputStreamValidatio, _inputStreamValidatio2;
    return inputStreamValidationResults === null || inputStreamValidationResults === void 0 ? void 0 : (_inputStreamValidatio = inputStreamValidationResults.vars) === null || _inputStreamValidatio === void 0 ? void 0 : (_inputStreamValidatio2 = _inputStreamValidatio[varName]) === null || _inputStreamValidatio2 === void 0 ? void 0 : _inputStreamValidatio2.length;
  }).length, [advancedVars, inputStreamValidationResults === null || inputStreamValidationResults === void 0 ? void 0 : inputStreamValidationResults.vars]);
  const setNewExperimentalDataFeatures = (0, _react.useCallback)(newFeatures => {
    if (!packagePolicy.package) {
      return;
    }
    updatePackagePolicy({
      package: {
        ...packagePolicy.package,
        experimental_data_stream_features: newFeatures
      }
    });
  }, [updatePackagePolicy, packagePolicy]);
  const {
    data: dataStreamsData
  } = (0, _reactQuery.useQuery)(['datastreams'], () => (0, _hooks.sendGetDataStreams)(), {
    enabled: packageInfo.type === 'input' // Only fetch datastream for input type package
  });

  const datasetList = (_uniq = (0, _lodash.uniq)(dataStreamsData === null || dataStreamsData === void 0 ? void 0 : dataStreamsData.data_streams)) !== null && _uniq !== void 0 ? _uniq : [];
  const datastreams = (0, _sort_datastreams.sortDatastreamsByDataset)(datasetList, packageInfo.name);

  // Showing advanced options toggle state
  const [isShowingAdvanced, setIsShowingAdvanced] = (0, _react.useState)(isDefaultDatastream);
  const hasAdvancedOptions = (0, _react.useMemo)(() => {
    return advancedVars.length > 0 || isPackagePolicyEdit && showPipelinesAndMappings || isExperimentalDataStreamSettingsEnabled;
  }, [advancedVars.length, isExperimentalDataStreamSettingsEnabled, isPackagePolicyEdit, showPipelinesAndMappings]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2
  }, /*#__PURE__*/_react.default.createElement(ScrollAnchor, {
    ref: containerRef
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "flexStart",
    justifyContent: "spaceBetween"
  }, packageInfo.type !== 'input' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: packageInputStream.title,
    disabled: packagePolicyInputStream.keep_enabled,
    checked: packagePolicyInputStream.enabled,
    onChange: e => {
      const enabled = e.target.checked;
      updatePackagePolicyInputStream({
        enabled
      });
    }
  })), packageInputStream.data_stream.release && packageInputStream.data_stream.release !== 'ga' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.InlineReleaseBadge, {
    release: (0, _services.mapPackageReleaseToIntegrationCardRelease)(packageInputStream.data_stream.release)
  })) : null), packageInfo.type !== 'input' && packageInputStream.description ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_reactMarkdown.default, null, packageInputStream.description))) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, requiredVars.map(varDef => {
    var _packagePolicyInputSt2, _varConfigEntry$froze;
    if (!(packagePolicyInputStream !== null && packagePolicyInputStream !== void 0 && packagePolicyInputStream.vars)) return null;
    const {
      name: varName,
      type: varType
    } = varDef;
    const varConfigEntry = (_packagePolicyInputSt2 = packagePolicyInputStream.vars) === null || _packagePolicyInputSt2 === void 0 ? void 0 : _packagePolicyInputSt2[varName];
    const value = varConfigEntry === null || varConfigEntry === void 0 ? void 0 : varConfigEntry.value;
    const frozen = (_varConfigEntry$froze = varConfigEntry === null || varConfigEntry === void 0 ? void 0 : varConfigEntry.frozen) !== null && _varConfigEntry$froze !== void 0 ? _varConfigEntry$froze : false;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: varName
    }, /*#__PURE__*/_react.default.createElement(_package_policy_input_var_field.PackagePolicyInputVarField, {
      varDef: varDef,
      value: value,
      frozen: frozen,
      onChange: newValue => {
        updatePackagePolicyInputStream({
          vars: {
            ...packagePolicyInputStream.vars,
            [varName]: {
              type: varType,
              value: newValue
            }
          }
        });
      },
      errors: inputStreamValidationResults === null || inputStreamValidationResults === void 0 ? void 0 : inputStreamValidationResults.vars[varName],
      forceShowErrors: forceShowErrors,
      packageType: packageInfo.type,
      packageName: packageInfo.name,
      datastreams: datastreams,
      isEditPage: isEditPage
    }));
  }), hasAdvancedOptions && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: isShowingAdvanced ? 'arrowDown' : 'arrowRight',
    onClick: () => setIsShowingAdvanced(!isShowingAdvanced),
    flush: "left",
    "data-test-subj": `advancedStreamOptionsToggle-${packagePolicyInputStream.id}`
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.toggleAdvancedOptionsButtonText",
    defaultMessage: "Advanced options"
  }))), !isShowingAdvanced && hasErrors && advancedVarsWithErrorsCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.errorCountText",
    defaultMessage: "{count, plural, one {# error} other {# errors}}",
    values: {
      count: advancedVarsWithErrorsCount
    }
  }))) : null)), isShowingAdvanced ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, advancedVars.map(varDef => {
    var _packagePolicyInputSt3, _packagePolicyInputSt4;
    if (!packagePolicyInputStream.vars) return null;
    const {
      name: varName,
      type: varType
    } = varDef;
    const value = (_packagePolicyInputSt3 = packagePolicyInputStream.vars) === null || _packagePolicyInputSt3 === void 0 ? void 0 : (_packagePolicyInputSt4 = _packagePolicyInputSt3[varName]) === null || _packagePolicyInputSt4 === void 0 ? void 0 : _packagePolicyInputSt4.value;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: varName
    }, /*#__PURE__*/_react.default.createElement(_package_policy_input_var_field.PackagePolicyInputVarField, {
      varDef: varDef,
      value: value,
      onChange: newValue => {
        updatePackagePolicyInputStream({
          vars: {
            ...packagePolicyInputStream.vars,
            [varName]: {
              type: varType,
              value: newValue
            }
          }
        });
      },
      errors: inputStreamValidationResults === null || inputStreamValidationResults === void 0 ? void 0 : inputStreamValidationResults.vars[varName],
      forceShowErrors: forceShowErrors,
      packageType: packageInfo.type,
      packageName: packageInfo.name,
      datastreams: datastreams,
      isEditPage: isEditPage
    }));
  }), isPackagePolicyEdit && showPipelinesAndMappings && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_datastream_pipelines.PackagePolicyEditorDatastreamPipelines, {
    packageInputStream: packagePolicyInputStream,
    packageInfo: packageInfo,
    customDataset: customDatasetVarValue
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_datastream_mappings.PackagePolicyEditorDatastreamMappings, {
    packageInputStream: packagePolicyInputStream,
    packageInfo: packageInfo,
    customDataset: customDatasetVarValue
  }))), isExperimentalDataStreamSettingsEnabled && /*#__PURE__*/_react.default.createElement(_experimental_datastream_settings.ExperimentDatastreamSettings, {
    registryDataStream: packageInputStream.data_stream,
    experimentalDataFeatures: (_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.experimental_data_stream_features,
    setNewExperimentalDataFeatures: setNewExperimentalDataFeatures
  })) : null)))));
});
exports.PackagePolicyInputStreamConfig = PackagePolicyInputStreamConfig;