"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExperimentDatastreamSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../../../../../hooks");
var _services = require("../../../../../../../../../common/services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getExperimentalFeatureValue(feature, experimentalDataFeatures, registryDataStream) {
  var _experimentalDataFeat, _experimentalDataFeat2;
  return experimentalDataFeatures === null || experimentalDataFeatures === void 0 ? void 0 : (_experimentalDataFeat = experimentalDataFeatures.find(({
    data_stream: dataStream,
    features
  }) => dataStream === (0, _services.getRegistryDataStreamAssetBaseName)(registryDataStream) && typeof features[feature] !== 'undefined')) === null || _experimentalDataFeat === void 0 ? void 0 : (_experimentalDataFeat2 = _experimentalDataFeat.features) === null || _experimentalDataFeat2 === void 0 ? void 0 : _experimentalDataFeat2[feature];
}
const ExperimentDatastreamSettings = ({
  registryDataStream,
  experimentalDataFeatures,
  setNewExperimentalDataFeatures
}) => {
  var _registryDataStream$e, _registryDataStream$e2, _registryDataStream$e3, _getExperimentalFeatu, _newExperimentalIndex, _newExperimentalIndex2, _newExperimentalIndex3, _newExperimentalIndex4, _newExperimentalIndex5;
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const isSyntheticSourceEditable = ((_registryDataStream$e = registryDataStream.elasticsearch) === null || _registryDataStream$e === void 0 ? void 0 : _registryDataStream$e.source_mode) !== 'default';
  const syntheticSourceExperimentalValue = getExperimentalFeatureValue('synthetic_source', experimentalDataFeatures !== null && experimentalDataFeatures !== void 0 ? experimentalDataFeatures : [], registryDataStream);
  const isTimeSeriesEnabledByDefault = ((_registryDataStream$e2 = registryDataStream.elasticsearch) === null || _registryDataStream$e2 === void 0 ? void 0 : _registryDataStream$e2.index_mode) === 'time_series';
  const isSyntheticSourceEnabledByDefault = ((_registryDataStream$e3 = registryDataStream.elasticsearch) === null || _registryDataStream$e3 === void 0 ? void 0 : _registryDataStream$e3.source_mode) === 'synthetic' || isTimeSeriesEnabledByDefault;
  const docValueOnlyNumericExperimentalValue = getExperimentalFeatureValue('doc_value_only_numeric', experimentalDataFeatures !== null && experimentalDataFeatures !== void 0 ? experimentalDataFeatures : [], registryDataStream);
  const docValueOnlyOtherExperimentalValue = getExperimentalFeatureValue('doc_value_only_other', experimentalDataFeatures !== null && experimentalDataFeatures !== void 0 ? experimentalDataFeatures : [], registryDataStream);
  const newExperimentalIndexingFeature = {
    synthetic_source: typeof syntheticSourceExperimentalValue !== 'undefined' ? syntheticSourceExperimentalValue : isSyntheticSourceEnabledByDefault,
    tsdb: isTimeSeriesEnabledByDefault ? isTimeSeriesEnabledByDefault : (_getExperimentalFeatu = getExperimentalFeatureValue('tsdb', experimentalDataFeatures !== null && experimentalDataFeatures !== void 0 ? experimentalDataFeatures : [], registryDataStream)) !== null && _getExperimentalFeatu !== void 0 ? _getExperimentalFeatu : false,
    doc_value_only_numeric: typeof docValueOnlyNumericExperimentalValue !== 'undefined' ? docValueOnlyNumericExperimentalValue : false,
    doc_value_only_other: typeof docValueOnlyOtherExperimentalValue !== 'undefined' ? docValueOnlyOtherExperimentalValue : false
  };
  const onIndexingSettingChange = features => {
    var _experimentalDataFeat3;
    const newExperimentalDataStreamFeatures = (_experimentalDataFeat3 = experimentalDataFeatures === null || experimentalDataFeatures === void 0 ? void 0 : experimentalDataFeatures.map(feature => ({
      ...feature
    }))) !== null && _experimentalDataFeat3 !== void 0 ? _experimentalDataFeat3 : [];
    const dataStream = (0, _services.getRegistryDataStreamAssetBaseName)(registryDataStream);
    const existingSettingRecord = newExperimentalDataStreamFeatures.find(x => x.data_stream === dataStream);
    if (existingSettingRecord) {
      existingSettingRecord.features = {
        ...existingSettingRecord.features,
        ...features
      };
    } else {
      newExperimentalDataStreamFeatures.push({
        data_stream: dataStream,
        features: {
          ...newExperimentalIndexingFeature,
          ...features
        }
      });
    }
    setNewExperimentalDataFeatures(newExperimentalDataStreamFeatures);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.packagePolicyEditor.experimentalSettings.title",
    defaultMessage: "Indexing settings (technical preview)"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.packagePolicyEditor.stepConfigure.experimentalFeaturesDescription",
    defaultMessage: "Choose how you want to store backing indices for this data stream. Changing these settings may affect other properties."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.packagePolicyEditor.stepConfigure.experimentalFeaturesRolloverWarning",
    defaultMessage: "After changing these settings, you need to manually roll over the existing data stream for changes to take effect. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.datastreamsManualRollover,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.fleet.packagePolicyEditor.experimentalFeatureRolloverLearnMore', {
        defaultMessage: 'Learn more'
      }))
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: (_newExperimentalIndex = newExperimentalIndexingFeature.synthetic_source) !== null && _newExperimentalIndex !== void 0 ? _newExperimentalIndex : false,
    disabled: !isSyntheticSourceEditable,
    "data-test-subj": "packagePolicyEditor.syntheticSourceExperimentalFeature.switch",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packagePolicyEditor.experimentalFeatures.syntheticSourceLabel",
      defaultMessage: "Synthetic source"
    }),
    onChange: e => {
      onIndexingSettingChange({
        synthetic_source: e.target.checked
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isTimeSeriesEnabledByDefault ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: (_newExperimentalIndex2 = newExperimentalIndexingFeature.tsdb) !== null && _newExperimentalIndex2 !== void 0 ? _newExperimentalIndex2 : false,
    disabled: true,
    "data-test-subj": "packagePolicyEditor.tsdbExperimentalFeature.switchTooltip",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packagePolicyEditor.experimentalFeatures.TSDBLabel",
      defaultMessage: "Time-series database (TSDB) indexing"
    }),
    onChange: e => {
      onIndexingSettingChange({
        tsdb: e.target.checked
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.fleet.packagePolicyEditor.experimentalFeatures.tooltip', {
      defaultMessage: 'TSDB indexing is enabled by the integration'
    }),
    position: "right",
    "data-test-subj": "foo"
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: (_newExperimentalIndex3 = newExperimentalIndexingFeature.tsdb) !== null && _newExperimentalIndex3 !== void 0 ? _newExperimentalIndex3 : false,
    "data-test-subj": "packagePolicyEditor.tsdbExperimentalFeature.switch",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packagePolicyEditor.experimentalFeatures.TSDBLabel",
      defaultMessage: "Time-series database (TSDB) indexing"
    }),
    onChange: e => {
      onIndexingSettingChange({
        tsdb: e.target.checked
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: (_newExperimentalIndex4 = newExperimentalIndexingFeature.doc_value_only_numeric) !== null && _newExperimentalIndex4 !== void 0 ? _newExperimentalIndex4 : false,
    "data-test-subj": "packagePolicyEditor.docValueOnlyNumericExperimentalFeature.switch",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packagePolicyEditor.experimentalFeatures.docValueOnlyNumericLabel",
      defaultMessage: "Doc value only (numeric types)"
    }),
    onChange: e => {
      onIndexingSettingChange({
        doc_value_only_numeric: e.target.checked
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: (_newExperimentalIndex5 = newExperimentalIndexingFeature.doc_value_only_other) !== null && _newExperimentalIndex5 !== void 0 ? _newExperimentalIndex5 : false,
    "data-test-subj": "packagePolicyEditor.docValueOnlyOtherExperimentalFeature.switch",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packagePolicyEditor.experimentalFeatures.docValueOnlyOtherLabel",
      defaultMessage: "Doc value only (other types)"
    }),
    onChange: e => {
      onIndexingSettingChange({
        doc_value_only_other: e.target.checked
      });
    }
  }))));
};
exports.ExperimentDatastreamSettings = ExperimentDatastreamSettings;