"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = useBreadcrumbs;
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASE_BREADCRUMB = {
  href: _constants.pagePathGetters.base()[1],
  text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.appTitle', {
    defaultMessage: 'Fleet'
  })
};
const INTEGRATIONS_BASE_BREADCRUMB = {
  href: _constants.pagePathGetters.integrations()[1],
  text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.integrationsAppTitle', {
    defaultMessage: 'Integrations'
  }),
  useIntegrationsBasePath: true
};
const breadcrumbGetters = {
  base: () => [BASE_BREADCRUMB],
  policies: () => [BASE_BREADCRUMB, {
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.policiesPageTitle', {
      defaultMessage: 'Agent policies'
    })
  }],
  policies_list: () => [BASE_BREADCRUMB, {
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.policiesPageTitle', {
      defaultMessage: 'Agent policies'
    })
  }],
  policy_details: ({
    policyName
  }) => [BASE_BREADCRUMB, {
    href: _constants.pagePathGetters.policies()[1],
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.policiesPageTitle', {
      defaultMessage: 'Agent policies'
    })
  }, {
    text: policyName
  }],
  add_integration_to_policy: ({
    pkgTitle,
    pkgkey,
    integration
  }) => [INTEGRATIONS_BASE_BREADCRUMB, {
    href: _constants.pagePathGetters.integration_details_overview({
      pkgkey,
      integration
    })[1],
    text: pkgTitle,
    useIntegrationsBasePath: true
  }, {
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.addPackagePolicyPageTitle', {
      defaultMessage: 'Add integration'
    })
  }],
  edit_integration: ({
    policyName,
    policyId
  }) => [BASE_BREADCRUMB, {
    href: _constants.pagePathGetters.policies()[1],
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.policiesPageTitle', {
      defaultMessage: 'Agent policies'
    })
  }, {
    href: _constants.pagePathGetters.policy_details({
      policyId
    })[1],
    text: policyName
  }, {
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.editPackagePolicyPageTitle', {
      defaultMessage: 'Edit integration'
    })
  }],
  upgrade_package_policy: ({
    policyName,
    policyId
  }) => [BASE_BREADCRUMB, {
    href: _constants.pagePathGetters.policies()[1],
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.policiesPageTitle', {
      defaultMessage: 'Agent policies'
    })
  }, {
    href: _constants.pagePathGetters.policy_details({
      policyId
    })[1],
    text: policyName
  }, {
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.upgradePackagePolicyPageTitle', {
      defaultMessage: 'Upgrade integration '
    })
  }],
  agent_list: () => [BASE_BREADCRUMB, {
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.agentsPageTitle', {
      defaultMessage: 'Agents'
    })
  }],
  agent_details: ({
    agentHost
  }) => [BASE_BREADCRUMB, {
    href: _constants.pagePathGetters.agent_list({})[1],
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.agentsPageTitle', {
      defaultMessage: 'Agents'
    })
  }, {
    text: agentHost
  }],
  enrollment_tokens: () => [BASE_BREADCRUMB, {
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.enrollmentTokensPageTitle', {
      defaultMessage: 'Enrollment tokens'
    })
  }],
  data_streams: () => [BASE_BREADCRUMB, {
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.datastreamsPageTitle', {
      defaultMessage: 'Data streams'
    })
  }],
  settings: () => [BASE_BREADCRUMB, {
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.settingsPageTitle', {
      defaultMessage: 'Settings'
    })
  }]
};
function useBreadcrumbs(page, values = {}) {
  var _breadcrumbGetters$pa;
  const {
    chrome,
    http,
    application
  } = (0, _.useStartServices)();
  const breadcrumbs = ((_breadcrumbGetters$pa = breadcrumbGetters[page]) === null || _breadcrumbGetters$pa === void 0 ? void 0 : _breadcrumbGetters$pa.call(breadcrumbGetters, values).map(breadcrumb => {
    const href = breadcrumb.href ? http.basePath.prepend(`${breadcrumb.useIntegrationsBasePath ? _constants.INTEGRATIONS_BASE_PATH : _constants.FLEET_BASE_PATH}${breadcrumb.href}`) : undefined;
    return {
      ...breadcrumb,
      href,
      onClick: href ? ev => {
        if (ev.metaKey || ev.altKey || ev.ctrlKey || ev.shiftKey) {
          return;
        }
        ev.preventDefault();
        application.navigateToUrl(href);
      } : undefined
    };
  })) || [];
  const docTitle = [...breadcrumbs].reverse().map(breadcrumb => breadcrumb.text);
  chrome.docTitle.change(docTitle);
  chrome.setBreadcrumbs(breadcrumbs);
}