"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/unified-search-plugin/public");
var _i18n = require("@kbn/i18n");
var _hooks = require("../hooks");
var _constants = require("../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HIDDEN_FIELDS = [`${_constants.AGENTS_PREFIX}.actions`, '_id', '_index'];
const NoWrapQueryStringInput = (0, _styledComponents.default)(_public.QueryStringInput)`
  .kbnQueryBar__textarea {
    white-space: nowrap;
  }
`;
const SearchBar = ({
  value,
  fieldPrefix,
  onChange,
  placeholder,
  indexPattern = _constants.INDEX_NAME,
  dataTestSubj
}) => {
  const {
    data,
    dataViews,
    unifiedSearch,
    storage,
    notifications,
    http,
    docLinks,
    uiSettings,
    usageCollection
  } = (0, _hooks.useStartServices)();
  const [dataView, setDataView] = (0, _react.useState)();
  const isQueryValid = (0, _react.useMemo)(() => {
    if (!value || value === '') {
      return true;
    }
    try {
      (0, _esQuery.fromKueryExpression)(value);
      return true;
    } catch (e) {
      return false;
    }
  }, [value]);
  (0, _react.useEffect)(() => {
    const fetchFields = async () => {
      try {
        const _fields = await data.dataViews.getFieldsForWildcard({
          pattern: indexPattern
        });
        const fields = (_fields || []).filter(field => {
          if (!fieldPrefix || field.name.startsWith(fieldPrefix)) {
            for (const hiddenField of HIDDEN_FIELDS) {
              if (field.name.startsWith(hiddenField)) {
                return false;
              }
            }
            return true;
          }
        });
        const fieldsMap = fields.reduce((acc, curr) => {
          acc[curr.name] = curr;
          return acc;
        }, {});
        const newDataView = await data.dataViews.create({
          title: indexPattern,
          fields: fieldsMap
        });
        setDataView(newDataView);
      } catch (err) {
        setDataView(undefined);
      }
    };
    fetchFields();
  }, [data.dataViews, fieldPrefix, indexPattern]);
  return /*#__PURE__*/_react.default.createElement(NoWrapQueryStringInput, (0, _extends2.default)({
    iconType: "search",
    disableLanguageSwitcher: true,
    indexPatterns: dataView ? [dataView] : [],
    query: {
      query: value,
      language: 'kuery'
    },
    isInvalid: !isQueryValid,
    disableAutoFocus: true,
    placeholder: placeholder,
    onChange: newQuery => {
      onChange(newQuery.query);
    },
    onSubmit: newQuery => {
      onChange(newQuery.query, true);
    },
    submitOnBlur: true,
    isClearable: true,
    autoSubmit: true,
    appName: _i18n.i18n.translate('xpack.fleet.appTitle', {
      defaultMessage: 'Fleet'
    }),
    deps: {
      unifiedSearch,
      notifications,
      http,
      docLinks,
      uiSettings,
      data,
      dataViews,
      storage,
      usageCollection
    }
  }, dataTestSubj && {
    dataTestSubj
  }));
};
exports.SearchBar = SearchBar;