"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGenerateServiceTokenStep = exports.ContentWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlexItemWithMinWidth = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-width: 0px;
  max-width: 100%;
`;
const ContentWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: 100%;
  margin: 0 auto;
  max-width: 800px;
`;

// Otherwise the copy button is over the text
exports.ContentWrapper = ContentWrapper;
const CommandCode = _styledComponents.default.div.attrs(() => {
  return {
    className: 'eui-textBreakAll'
  };
})`
  margin-right: ${props => props.theme.eui.euiSizeM};
`;
const getGenerateServiceTokenStep = ({
  disabled = false,
  serviceToken,
  generateServiceToken,
  isLoadingServiceToken
}) => {
  return {
    title: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.stepGenerateServiceTokenTitle', {
      defaultMessage: 'Generate a service token'
    }),
    status: disabled ? 'disabled' : undefined,
    children: !disabled && /*#__PURE__*/_react.default.createElement(ServiceTokenStepContent, {
      serviceToken: serviceToken,
      generateServiceToken: generateServiceToken,
      isLoadingServiceToken: isLoadingServiceToken
    })
  };
};
exports.getGenerateServiceTokenStep = getGenerateServiceTokenStep;
const ServiceTokenStepContent = ({
  serviceToken,
  generateServiceToken,
  isLoadingServiceToken
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerSetup.generateServiceTokenDescription",
    defaultMessage: "A service token grants Fleet Server permissions to write to Elasticsearch."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !serviceToken ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isLoading: isLoadingServiceToken,
    isDisabled: isLoadingServiceToken,
    onClick: () => {
      generateServiceToken();
    },
    "data-test-subj": "fleetServerGenerateServiceTokenBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerSetup.generateServiceTokenButton",
    defaultMessage: "Generate service token"
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "check",
    size: "s",
    color: "success",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.saveServiceTokenDescription",
      defaultMessage: "Save your service token information. This will be shown only once."
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("strong", {
    "data-test-subject": "serviceTokenSaveReminderHeader"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerSetup.serviceTokenLabel",
    defaultMessage: "Service token"
  }))), /*#__PURE__*/_react.default.createElement(FlexItemWithMinWidth, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    paddingSize: "m",
    isCopyable: true
  }, /*#__PURE__*/_react.default.createElement(CommandCode, null, serviceToken))))));
};