"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllowedOutputTypeForPolicy = getAllowedOutputTypeForPolicy;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Return allowed output type for a given agent policy,
 * Fleet Server and APM cannot use anything else than same cluster ES
 */
function getAllowedOutputTypeForPolicy(agentPolicy) {
  const isRestrictedToSameClusterES = agentPolicy.package_policies && agentPolicy.package_policies.some(p => {
    var _p$package, _p$package2;
    return ((_p$package = p.package) === null || _p$package === void 0 ? void 0 : _p$package.name) === _constants.FLEET_APM_PACKAGE || ((_p$package2 = p.package) === null || _p$package2 === void 0 ? void 0 : _p$package2.name) === _constants.FLEET_SERVER_PACKAGE;
  });
  if (isRestrictedToSameClusterES) {
    return [_constants.outputType.Elasticsearch];
  }
  return Object.values(_constants.outputType);
}