"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MINIMUM_DIAGNOSTICS_AGENT_VERSION = void 0;
exports.isAgentRequestDiagnosticsSupported = isAgentRequestDiagnosticsSupported;
var _gte = _interopRequireDefault(require("semver/functions/gte"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MINIMUM_DIAGNOSTICS_AGENT_VERSION = '8.7.0';
exports.MINIMUM_DIAGNOSTICS_AGENT_VERSION = MINIMUM_DIAGNOSTICS_AGENT_VERSION;
function isAgentRequestDiagnosticsSupported(agent) {
  var _agent$local_metadata, _agent$local_metadata2, _agent$local_metadata3;
  if (!agent.active) {
    return false;
  }
  if (typeof (agent === null || agent === void 0 ? void 0 : (_agent$local_metadata = agent.local_metadata) === null || _agent$local_metadata === void 0 ? void 0 : (_agent$local_metadata2 = _agent$local_metadata.elastic) === null || _agent$local_metadata2 === void 0 ? void 0 : (_agent$local_metadata3 = _agent$local_metadata2.agent) === null || _agent$local_metadata3 === void 0 ? void 0 : _agent$local_metadata3.version) !== 'string') {
    return false;
  }
  const agentVersion = agent.local_metadata.elastic.agent.version;
  return (0, _gte.default)(agentVersion, MINIMUM_DIAGNOSTICS_AGENT_VERSION);
}