"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilesPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _file_kinds_registry = require("../common/file_kinds_registry");
var _files_client = require("./files_client");
var DefaultImageFileKind = _interopRequireWildcard(require("../common/default_image_file_kind"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Bringing files to Kibana
 */
class FilesPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "registry", new _file_kinds_registry.FileKindsRegistryImpl());
    (0, _defineProperty2.default)(this, "filesClientFactory", void 0);
  }
  setup(core) {
    this.registry.register({
      ...DefaultImageFileKind.kind,
      maxSizeBytes: DefaultImageFileKind.maxSize
    });
    this.filesClientFactory = {
      asScoped: fileKind => {
        return (0, _files_client.createFilesClient)({
          registry: this.registry,
          fileKind,
          http: core.http
        });
      },
      asUnscoped: () => {
        return (0, _files_client.createFilesClient)({
          registry: this.registry,
          http: core.http
        });
      }
    };
    return {
      filesClientFactory: this.filesClientFactory,
      registerFileKind: fileKind => {
        this.registry.register(fileKind);
      }
    };
  }
  start(core) {
    return {
      filesClientFactory: this.filesClientFactory,
      getFileKindDefinition: id => {
        return this.registry.get(id);
      },
      getAllFindKindDefinitions: () => {
        return this.registry.getAll();
      }
    };
  }
}
exports.FilesPlugin = FilesPlugin;