"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _contentManagementTableList = require("@kbn/content-management-table-list");
var _reactQuery = require("@tanstack/react-query");
var _app = require("./app");
var _context = require("./context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const queryClient = new _reactQuery.QueryClient();
const mountManagementSection = (coreStart, startDeps, {
  element,
  history
}) => {
  const {
    files: {
      filesClientFactory,
      getAllFindKindDefinitions,
      getFileKindDefinition
    }
  } = startDeps;
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_contentManagementTableList.TableListViewKibanaProvider, {
    core: coreStart,
    toMountPoint: _public.toMountPoint,
    FormattedRelative: _i18nReact.FormattedRelative
  }, /*#__PURE__*/_react.default.createElement(_context.FilesManagementAppContextProvider, {
    filesClient: filesClientFactory.asUnscoped(),
    getFileKindDefinition: getFileKindDefinition,
    getAllFindKindDefinitions: getAllFindKindDefinitions
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/",
    component: _app.App
  })))))), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.mountManagementSection = mountManagementSection;